/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.epl.datetime.eval.ExprDotNodeFilterAnalyzerDesc;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.dot.ExprDotNode;
import com.espertech.esper.epl.expression.ops.ExprAndNode;
import com.espertech.esper.epl.expression.ops.ExprBetweenNode;
import com.espertech.esper.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.epl.expression.ops.ExprInNode;
import com.espertech.esper.epl.expression.ops.ExprOrNode;
import com.espertech.esper.epl.expression.ops.ExprRelationalOpNode;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.util.Eligibility;
import com.espertech.esper.epl.join.util.EligibilityDesc;
import com.espertech.esper.epl.join.util.EligibilityUtil;
import com.espertech.esper.epl.join.util.RangeFilterAnalyzer;
import com.espertech.esper.filter.FilterSpecCompilerMakeParamUtil;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FilterExprAnalyzer {
    public static void analyze(ExprNode topNode, QueryGraph queryGraph, boolean isOuterJoin) {
        ExprNode rewritten;
        if (topNode instanceof ExprEqualsNode) {
            ExprEqualsNode equalsNode = (ExprEqualsNode)topNode;
            if (!equalsNode.isNotEquals()) {
                FilterExprAnalyzer.analyzeEqualsNode(equalsNode, queryGraph, isOuterJoin);
            }
        } else if (topNode instanceof ExprAndNode) {
            ExprAndNode andNode = (ExprAndNode)topNode;
            FilterExprAnalyzer.analyzeAndNode(andNode, queryGraph, isOuterJoin);
        } else if (topNode instanceof ExprBetweenNode) {
            ExprBetweenNode betweenNode = (ExprBetweenNode)topNode;
            FilterExprAnalyzer.analyzeBetweenNode(betweenNode, queryGraph);
        } else if (topNode instanceof ExprRelationalOpNode) {
            ExprRelationalOpNode relNode = (ExprRelationalOpNode)topNode;
            FilterExprAnalyzer.analyzeRelationalOpNode(relNode, queryGraph);
        } else if (topNode instanceof ExprDotNode && !isOuterJoin) {
            ExprDotNode dotNode = (ExprDotNode)topNode;
            FilterExprAnalyzer.analyzeDotNode(dotNode, queryGraph);
        } else if (topNode instanceof ExprInNode) {
            ExprInNode inNode = (ExprInNode)topNode;
            FilterExprAnalyzer.analyzeInNode(inNode, queryGraph);
        } else if (topNode instanceof ExprOrNode && (rewritten = FilterSpecCompilerMakeParamUtil.rewriteOrToInIfApplicable(topNode)) instanceof ExprInNode) {
            ExprInNode inNode = (ExprInNode)rewritten;
            FilterExprAnalyzer.analyzeInNode(inNode, queryGraph);
        }
    }

    private static void analyzeInNode(ExprInNode inNode, QueryGraph queryGraph) {
        if (inNode.isNotIn()) {
            return;
        }
        FilterExprAnalyzer.analyzeInNodeSingleIndex(inNode, queryGraph);
        FilterExprAnalyzer.analyzeInNodeMultiIndex(inNode, queryGraph);
    }

    private static void analyzeInNodeMultiIndex(ExprInNode inNode, QueryGraph queryGraph) {
        Integer testStreamNum;
        ExprNode[] exprNodes;
        ExprNode[] setExpressions = FilterExprAnalyzer.getInNodeSetExpressions(inNode);
        if (setExpressions.length == 0) {
            return;
        }
        LinkedHashMap<Integer, List<ExprNode>> perStreamExprs = new LinkedHashMap<Integer, List<ExprNode>>();
        for (ExprNode exprNodeSet : setExpressions) {
            if (!(exprNodeSet instanceof ExprIdentNode)) continue;
            ExprNode[] setIdent = (ExprNode[])exprNodeSet;
            FilterExprAnalyzer.addToList(setIdent.getStreamId(), (ExprNode)setIdent, perStreamExprs);
        }
        if (perStreamExprs.isEmpty()) {
            return;
        }
        ExprNode testExpr = inNode.getChildNodes()[0];
        Class testExprType = JavaClassHelper.getBoxedType(testExpr.getExprEvaluator().getType());
        if (perStreamExprs.size() > 1) {
            return;
        }
        Map.Entry entry = perStreamExprs.entrySet().iterator().next();
        for (ExprNode node : exprNodes = ExprNodeUtility.toArray((Collection)entry.getValue())) {
            Class exprType = node.getExprEvaluator().getType();
            if (JavaClassHelper.getBoxedType(exprType) == testExprType) continue;
            return;
        }
        int setStream = (Integer)entry.getKey();
        if (!(testExpr instanceof ExprIdentNode)) {
            EligibilityDesc eligibility = EligibilityUtil.verifyInputStream(testExpr, setStream);
            if (!eligibility.getEligibility().isEligible()) {
                return;
            }
            if (eligibility.getEligibility() == Eligibility.REQUIRE_ONE && setStream == eligibility.getStreamNum()) {
                return;
            }
            testStreamNum = eligibility.getStreamNum();
        } else {
            testStreamNum = ((ExprIdentNode)testExpr).getStreamId();
        }
        if (testStreamNum == null) {
            queryGraph.addInSetMultiIndexUnkeyed(testExpr, setStream, exprNodes);
        } else {
            if (testStreamNum.equals(entry.getKey())) {
                return;
            }
            queryGraph.addInSetMultiIndex(testStreamNum, testExpr, setStream, exprNodes);
        }
    }

    private static void analyzeInNodeSingleIndex(ExprInNode inNode, QueryGraph queryGraph) {
        if (!(inNode.getChildNodes()[0] instanceof ExprIdentNode)) {
            return;
        }
        ExprIdentNode testIdent = (ExprIdentNode)inNode.getChildNodes()[0];
        Class testIdentClass = JavaClassHelper.getBoxedType(testIdent.getExprEvaluator().getType());
        int indexedStream = testIdent.getStreamId();
        ExprNode[] setExpressions = FilterExprAnalyzer.getInNodeSetExpressions(inNode);
        if (setExpressions.length == 0) {
            return;
        }
        LinkedHashMap<Integer, List<ExprNode>> perStreamExprs = new LinkedHashMap<Integer, List<ExprNode>>();
        for (ExprNode exprNodeSet : setExpressions) {
            if (JavaClassHelper.getBoxedType(exprNodeSet.getExprEvaluator().getType()) != testIdentClass) continue;
            if (exprNodeSet instanceof ExprIdentNode) {
                ExprIdentNode setIdent = (ExprIdentNode)exprNodeSet;
                FilterExprAnalyzer.addToList(setIdent.getStreamId(), setIdent, perStreamExprs);
                continue;
            }
            EligibilityDesc eligibility = EligibilityUtil.verifyInputStream(exprNodeSet, indexedStream);
            if (!eligibility.getEligibility().isEligible()) continue;
            FilterExprAnalyzer.addToList(eligibility.getStreamNum(), exprNodeSet, perStreamExprs);
        }
        for (Map.Entry entry : perStreamExprs.entrySet()) {
            ExprNode[] exprNodes = ExprNodeUtility.toArray((Collection)entry.getValue());
            if (entry.getKey() == null) {
                queryGraph.addInSetSingleIndexUnkeyed(testIdent.getStreamId(), testIdent, exprNodes);
                continue;
            }
            if ((Integer)entry.getKey() == indexedStream) continue;
            queryGraph.addInSetSingleIndex(testIdent.getStreamId(), testIdent, (Integer)entry.getKey(), exprNodes);
        }
    }

    private static void addToList(Integer streamIdAllowNull, ExprNode expr, Map<Integer, List<ExprNode>> perStreamExpression) {
        List<ExprNode> perStream = perStreamExpression.get(streamIdAllowNull);
        if (perStream == null) {
            perStream = new ArrayList<ExprNode>();
            perStreamExpression.put(streamIdAllowNull, perStream);
        }
        perStream.add(expr);
    }

    private static ExprNode[] getInNodeSetExpressions(ExprInNode inNode) {
        ExprNode[] setExpressions = new ExprNode[inNode.getChildNodes().length - 1];
        int count = 0;
        for (int i = 1; i < inNode.getChildNodes().length; ++i) {
            setExpressions[count++] = inNode.getChildNodes()[i];
        }
        return setExpressions;
    }

    private static void analyzeDotNode(ExprDotNode dotNode, QueryGraph queryGraph) {
        ExprDotNodeFilterAnalyzerDesc interval = dotNode.getExprDotNodeFilterAnalyzerDesc();
        if (interval == null) {
            return;
        }
        interval.apply(queryGraph);
    }

    private static void analyzeRelationalOpNode(ExprRelationalOpNode relNode, QueryGraph queryGraph) {
        if (relNode.getChildNodes()[0] instanceof ExprIdentNode && relNode.getChildNodes()[1] instanceof ExprIdentNode) {
            ExprIdentNode identNodeLeft = (ExprIdentNode)relNode.getChildNodes()[0];
            ExprIdentNode identNodeRight = (ExprIdentNode)relNode.getChildNodes()[1];
            if (identNodeLeft.getStreamId() != identNodeRight.getStreamId()) {
                queryGraph.addRelationalOpStrict(identNodeLeft.getStreamId(), identNodeLeft, identNodeRight.getStreamId(), identNodeRight, relNode.getRelationalOpEnum());
            }
            return;
        }
        int indexedStream = -1;
        ExprIdentNode indexedPropExpr = null;
        ExprNode exprNodeNoIdent = null;
        RelationalOpEnum relop = relNode.getRelationalOpEnum();
        if (relNode.getChildNodes()[0] instanceof ExprIdentNode) {
            indexedPropExpr = (ExprIdentNode)relNode.getChildNodes()[0];
            indexedStream = indexedPropExpr.getStreamId();
            exprNodeNoIdent = relNode.getChildNodes()[1];
        } else if (relNode.getChildNodes()[1] instanceof ExprIdentNode) {
            indexedPropExpr = (ExprIdentNode)relNode.getChildNodes()[1];
            indexedStream = indexedPropExpr.getStreamId();
            exprNodeNoIdent = relNode.getChildNodes()[0];
            relop = relop.reversed();
        }
        if (indexedStream == -1) {
            return;
        }
        EligibilityDesc eligibility = EligibilityUtil.verifyInputStream(exprNodeNoIdent, indexedStream);
        if (!eligibility.getEligibility().isEligible()) {
            return;
        }
        queryGraph.addRelationalOp(indexedStream, indexedPropExpr, eligibility.getStreamNum(), exprNodeNoIdent, relop);
    }

    private static void analyzeBetweenNode(ExprBetweenNode betweenNode, QueryGraph queryGraph) {
        RangeFilterAnalyzer.apply(betweenNode.getChildNodes()[0], betweenNode.getChildNodes()[1], betweenNode.getChildNodes()[2], betweenNode.isLowEndpointIncluded(), betweenNode.isHighEndpointIncluded(), betweenNode.isNotBetween(), queryGraph);
    }

    protected static void analyzeEqualsNode(ExprEqualsNode equalsNode, QueryGraph queryGraph, boolean isOuterJoin) {
        if (equalsNode.getChildNodes()[0] instanceof ExprIdentNode && equalsNode.getChildNodes()[1] instanceof ExprIdentNode) {
            ExprIdentNode identNodeLeft = (ExprIdentNode)equalsNode.getChildNodes()[0];
            ExprIdentNode identNodeRight = (ExprIdentNode)equalsNode.getChildNodes()[1];
            if (identNodeLeft.getStreamId() != identNodeRight.getStreamId()) {
                queryGraph.addStrictEquals(identNodeLeft.getStreamId(), identNodeLeft.getResolvedPropertyName(), identNodeLeft, identNodeRight.getStreamId(), identNodeRight.getResolvedPropertyName(), identNodeRight);
            }
            return;
        }
        if (isOuterJoin) {
            return;
        }
        int indexedStream = -1;
        ExprIdentNode indexedPropExpr = null;
        ExprNode exprNodeNoIdent = null;
        if (equalsNode.getChildNodes()[0] instanceof ExprIdentNode) {
            indexedPropExpr = (ExprIdentNode)equalsNode.getChildNodes()[0];
            indexedStream = indexedPropExpr.getStreamId();
            exprNodeNoIdent = equalsNode.getChildNodes()[1];
        } else if (equalsNode.getChildNodes()[1] instanceof ExprIdentNode) {
            indexedPropExpr = (ExprIdentNode)equalsNode.getChildNodes()[1];
            indexedStream = indexedPropExpr.getStreamId();
            exprNodeNoIdent = equalsNode.getChildNodes()[0];
        }
        if (indexedStream == -1) {
            return;
        }
        EligibilityDesc eligibility = EligibilityUtil.verifyInputStream(exprNodeNoIdent, indexedStream);
        if (!eligibility.getEligibility().isEligible()) {
            return;
        }
        if (eligibility.getEligibility() == Eligibility.REQUIRE_NONE) {
            queryGraph.addUnkeyedExpression(indexedStream, indexedPropExpr, exprNodeNoIdent);
        } else {
            queryGraph.addKeyedExpression(indexedStream, indexedPropExpr, eligibility.getStreamNum(), exprNodeNoIdent);
        }
    }

    protected static void analyzeAndNode(ExprAndNode andNode, QueryGraph queryGraph, boolean isOuterJoin) {
        for (ExprNode childNode : andNode.getChildNodes()) {
            FilterExprAnalyzer.analyze(childNode, queryGraph, isOuterJoin);
        }
    }
}

