/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.join.exec.base.IndexedTableLookupStrategy;
import com.espertech.esper.epl.join.exec.base.IndexedTableLookupStrategyExpr;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedProp;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.plan.TableLookupKeyDesc;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.LookupStrategyType;
import java.util.Collections;
import java.util.List;

public class IndexedTableLookupPlanMulti
extends TableLookupPlan {
    private List<QueryGraphValueEntryHashKeyed> keyProperties;

    public IndexedTableLookupPlanMulti(int lookupStream, int indexedStream, TableLookupIndexReqKey indexNum, List<QueryGraphValueEntryHashKeyed> keyProperties) {
        super(lookupStream, indexedStream, new TableLookupIndexReqKey[]{indexNum});
        this.keyProperties = keyProperties;
    }

    @Override
    public TableLookupKeyDesc getKeyDescriptor() {
        return new TableLookupKeyDesc(this.keyProperties, Collections.emptyList());
    }

    @Override
    public JoinExecTableLookupStrategy makeStrategyInternal(EventTable[] eventTable, EventType[] eventTypes) {
        PropertyIndexedEventTable index = (PropertyIndexedEventTable)eventTable[0];
        String[] keyProps = new String[this.keyProperties.size()];
        ExprEvaluator[] evaluators = new ExprEvaluator[this.keyProperties.size()];
        String[] expressions = new String[this.keyProperties.size()];
        boolean isStrictlyProps = true;
        for (int i = 0; i < keyProps.length; ++i) {
            isStrictlyProps = isStrictlyProps && this.keyProperties.get(i) instanceof QueryGraphValueEntryHashKeyedProp;
            evaluators[i] = this.keyProperties.get(i).getKeyExpr().getExprEvaluator();
            expressions[i] = ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this.keyProperties.get(i).getKeyExpr());
            if (this.keyProperties.get(i) instanceof QueryGraphValueEntryHashKeyedProp) {
                keyProps[i] = ((QueryGraphValueEntryHashKeyedProp)this.keyProperties.get(i)).getKeyProperty();
                continue;
            }
            isStrictlyProps = false;
        }
        if (isStrictlyProps) {
            return new IndexedTableLookupStrategy(eventTypes[this.getLookupStream()], keyProps, index);
        }
        return new IndexedTableLookupStrategyExpr(evaluators, this.getLookupStream(), index, new LookupStrategyDesc(LookupStrategyType.MULTIEXPR, expressions));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + super.toString() + " keyProperties=" + QueryGraphValueEntryHashKeyed.toQueryPlan(this.keyProperties);
    }
}

