/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.NumberSetPermutationEnumeration;
import com.espertech.esper.collection.NumberSetShiftGroupEnumeration;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.plan.CoercionUtil;
import com.espertech.esper.epl.join.plan.CompositeTableLookupPlan;
import com.espertech.esper.epl.join.plan.FullTableScanLookupPlan;
import com.espertech.esper.epl.join.plan.FullTableScanUniquePerKeyLookupPlan;
import com.espertech.esper.epl.join.plan.HistoricalDataPlanNode;
import com.espertech.esper.epl.join.plan.InKeywordTableLookupPlanMultiIdx;
import com.espertech.esper.epl.join.plan.InKeywordTableLookupPlanSingleIdx;
import com.espertech.esper.epl.join.plan.IndexedTableLookupPlanMulti;
import com.espertech.esper.epl.join.plan.IndexedTableLookupPlanSingle;
import com.espertech.esper.epl.join.plan.NestedIterationNode;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryGraphValue;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryInKeywordSingleIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairInKWMultiIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairInKWSingleIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairRangeIndex;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import com.espertech.esper.epl.join.plan.QueryPlanIndexBuilder;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.plan.QueryPlanNodeNoOp;
import com.espertech.esper.epl.join.plan.SortedTableLookupPlan;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.plan.TableLookupNode;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.lookup.EventTableIndexEntryBase;
import com.espertech.esper.epl.lookup.EventTableIndexUtil;
import com.espertech.esper.epl.lookup.IndexKeyInfo;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import com.espertech.esper.epl.lookup.SubordinateQueryPlannerUtil;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.util.DependencyGraph;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NStreamQueryPlanBuilder {
    private static Logger log = LoggerFactory.getLogger(NStreamQueryPlanBuilder.class);

    protected static QueryPlan build(QueryGraph queryGraph, EventType[] typesPerStream, HistoricalViewableDesc historicalViewableDesc, DependencyGraph dependencyGraph, HistoricalStreamIndexList[] historicalStreamIndexLists, boolean hasForceNestedIter, String[][][] indexedStreamsUniqueProps, TableMetadata[] tablesPerStream) {
        if (log.isDebugEnabled()) {
            log.debug(".build queryGraph=" + queryGraph);
        }
        int numStreams = queryGraph.getNumStreams();
        QueryPlanIndex[] indexSpecs = QueryPlanIndexBuilder.buildIndexSpec(queryGraph, typesPerStream, indexedStreamsUniqueProps);
        if (log.isDebugEnabled()) {
            log.debug(".build Index build completed, indexes=" + QueryPlanIndex.print(indexSpecs));
        }
        if (historicalViewableDesc.isHasHistorical()) {
            for (int i = 0; i < historicalViewableDesc.getHistorical().length; ++i) {
                if (!historicalViewableDesc.getHistorical()[i]) continue;
                indexSpecs[i] = null;
            }
        }
        QueryPlanNode[] planNodeSpecs = new QueryPlanNode[numStreams];
        int worstDepth = Integer.MAX_VALUE;
        for (int streamNo = 0; streamNo < numStreams; ++streamNo) {
            if (historicalViewableDesc.getHistorical()[streamNo] && dependencyGraph.hasDependency(streamNo)) {
                planNodeSpecs[streamNo] = new QueryPlanNodeNoOp();
                continue;
            }
            BestChainResult bestChainResult = NStreamQueryPlanBuilder.computeBestPath(streamNo, queryGraph, dependencyGraph);
            int[] bestChain = bestChainResult.getChain();
            if (log.isDebugEnabled()) {
                log.debug(".build For stream " + streamNo + " bestChain=" + Arrays.toString(bestChain));
            }
            if (bestChainResult.depth < worstDepth) {
                worstDepth = bestChainResult.depth;
            }
            planNodeSpecs[streamNo] = NStreamQueryPlanBuilder.createStreamPlan(streamNo, bestChain, queryGraph, indexSpecs, typesPerStream, historicalViewableDesc.getHistorical(), historicalStreamIndexLists, tablesPerStream);
            if (!log.isDebugEnabled()) continue;
            log.debug(".build spec=" + planNodeSpecs[streamNo]);
        }
        if (worstDepth < numStreams - 1 && !hasForceNestedIter) {
            return null;
        }
        return new QueryPlan(indexSpecs, planNodeSpecs);
    }

    protected static QueryPlanNode createStreamPlan(int lookupStream, int[] bestChain, QueryGraph queryGraph, QueryPlanIndex[] indexSpecsPerStream, EventType[] typesPerStream, boolean[] isHistorical, HistoricalStreamIndexList[] historicalStreamIndexLists, TableMetadata[] tablesPerStream) {
        NestedIterationNode nestedIterNode = new NestedIterationNode(bestChain);
        int currentLookupStream = lookupStream;
        for (int i = 0; i < bestChain.length; ++i) {
            QueryPlanNode node;
            int indexedStream = bestChain[i];
            if (isHistorical[indexedStream]) {
                if (historicalStreamIndexLists[indexedStream] == null) {
                    historicalStreamIndexLists[indexedStream] = new HistoricalStreamIndexList(indexedStream, typesPerStream, queryGraph);
                }
                historicalStreamIndexLists[indexedStream].addIndex(currentLookupStream);
                node = new HistoricalDataPlanNode(indexedStream, lookupStream, currentLookupStream, typesPerStream.length, null);
            } else {
                TableLookupPlan tableLookupPlan = NStreamQueryPlanBuilder.createLookupPlan(queryGraph, currentLookupStream, indexedStream, indexSpecsPerStream[indexedStream], typesPerStream, tablesPerStream[indexedStream]);
                node = new TableLookupNode(tableLookupPlan);
            }
            nestedIterNode.addChildNode(node);
            currentLookupStream = bestChain[i];
        }
        return nestedIterNode;
    }

    public static TableLookupPlan createLookupPlan(QueryGraph queryGraph, int currentLookupStream, int indexedStream, QueryPlanIndex indexSpecs, EventType[] typesPerStream, TableMetadata indexedStreamTableMeta) {
        int i;
        TableLookupIndexReqKey indexNum;
        QueryGraphValue queryGraphValue = queryGraph.getGraphValue(currentLookupStream, indexedStream);
        QueryGraphValuePairHashKeyIndex hashKeyProps = queryGraphValue.getHashKeyProps();
        List<QueryGraphValueEntryHashKeyed> hashPropsKeys = hashKeyProps.getKeys();
        Object[] hashIndexProps = hashKeyProps.getIndexed();
        QueryGraphValuePairRangeIndex rangeProps = queryGraphValue.getRangeProps();
        List<QueryGraphValueEntryRange> rangePropsKeys = rangeProps.getKeys();
        Object[] rangeIndexProps = rangeProps.getIndexed();
        Pair<TableLookupIndexReqKey, int[]> pairIndexHashRewrite = indexSpecs.getIndexNum((String[])hashIndexProps, (String[])rangeIndexProps);
        TableLookupIndexReqKey tableLookupIndexReqKey = indexNum = pairIndexHashRewrite == null ? null : pairIndexHashRewrite.getFirst();
        if (pairIndexHashRewrite != null && pairIndexHashRewrite.getSecond() != null) {
            int[] indexes = pairIndexHashRewrite.getSecond();
            String[] newHashIndexProps = new String[indexes.length];
            ArrayList<QueryGraphValueEntryHashKeyed> newHashKeys = new ArrayList<QueryGraphValueEntryHashKeyed>();
            for (i = 0; i < indexes.length; ++i) {
                newHashIndexProps[i] = hashIndexProps[indexes[i]];
                newHashKeys.add(hashPropsKeys.get(indexes[i]));
            }
            hashIndexProps = newHashIndexProps;
            hashPropsKeys = newHashKeys;
            rangeIndexProps = new String[]{};
            rangePropsKeys = Collections.emptyList();
        }
        if (hashIndexProps.length == 0 && rangeIndexProps.length == 0) {
            List<QueryGraphValuePairInKWMultiIdx> multis;
            QueryGraphValuePairInKWSingleIdx singles = queryGraphValue.getInKeywordSingles();
            if (!singles.getKey().isEmpty()) {
                QueryGraphValueEntryInKeywordSingleIdx single = null;
                indexNum = null;
                if (indexedStreamTableMeta != null) {
                    String[] indexes = singles.getIndexed();
                    int count = 0;
                    for (String index : indexes) {
                        Pair<IndexMultiKey, EventTableIndexEntryBase> indexPairFound = EventTableIndexUtil.findIndexBestAvailable(indexedStreamTableMeta.getEventTableIndexMetadataRepo().getIndexes(), Collections.singleton(index), Collections.emptySet(), null);
                        if (indexPairFound != null) {
                            indexNum = new TableLookupIndexReqKey(indexPairFound.getSecond().getOptionalIndexName(), indexedStreamTableMeta.getTableName());
                            single = singles.getKey().get(count);
                        }
                        ++count;
                    }
                } else {
                    single = singles.getKey().get(0);
                    Pair<TableLookupIndexReqKey, int[]> pairIndex = indexSpecs.getIndexNum(new String[]{singles.getIndexed()[0]}, null);
                    indexNum = pairIndex.getFirst();
                }
                if (indexNum != null) {
                    return new InKeywordTableLookupPlanSingleIdx(currentLookupStream, indexedStream, indexNum, single.getKeyExprs());
                }
            }
            if (!(multis = queryGraphValue.getInKeywordMulti()).isEmpty()) {
                if (indexedStreamTableMeta != null) {
                    return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamTableMeta);
                }
                QueryGraphValuePairInKWMultiIdx multi = multis.get(0);
                TableLookupIndexReqKey[] indexNameArray = new TableLookupIndexReqKey[multi.getIndexed().length];
                boolean foundAll = true;
                for (int i2 = 0; i2 < multi.getIndexed().length; ++i2) {
                    ExprIdentNode identNode = (ExprIdentNode)multi.getIndexed()[i2];
                    Pair<TableLookupIndexReqKey, int[]> pairIndex = indexSpecs.getIndexNum(new String[]{identNode.getResolvedPropertyName()}, null);
                    if (pairIndex == null) {
                        foundAll = false;
                        continue;
                    }
                    indexNameArray[i2] = pairIndex.getFirst();
                }
                if (foundAll) {
                    return new InKeywordTableLookupPlanMultiIdx(currentLookupStream, indexedStream, indexNameArray, multi.getKey().getKeyExpr());
                }
            }
            if (indexedStreamTableMeta != null) {
                return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamTableMeta);
            }
            if (indexNum == null) {
                indexNum = new TableLookupIndexReqKey(indexSpecs.addIndex(null, null));
            }
            return new FullTableScanLookupPlan(currentLookupStream, indexedStream, indexNum);
        }
        if (indexNum == null) {
            throw new IllegalStateException("Failed to query plan as index for " + Arrays.toString(hashIndexProps) + " and " + Arrays.toString(rangeIndexProps) + " in the index specification");
        }
        if (indexedStreamTableMeta != null) {
            Pair<IndexMultiKey, EventTableIndexEntryBase> indexPairFound = EventTableIndexUtil.findIndexBestAvailable(indexedStreamTableMeta.getEventTableIndexMetadataRepo().getIndexes(), NStreamQueryPlanBuilder.toSet((String[])hashIndexProps), NStreamQueryPlanBuilder.toSet((String[])rangeIndexProps), null);
            if (indexPairFound != null) {
                IndexKeyInfo indexKeyInfo = SubordinateQueryPlannerUtil.compileIndexKeyInfo(indexPairFound.getFirst(), (String[])hashIndexProps, NStreamQueryPlanBuilder.getHashKeyFuncsAsSubProp(hashPropsKeys), (String[])rangeIndexProps, NStreamQueryPlanBuilder.getRangeFuncsAsSubProp(rangePropsKeys));
                if (indexKeyInfo.getOrderedKeyCoercionTypes().isCoerce() || indexKeyInfo.getOrderedRangeCoercionTypes().isCoerce()) {
                    return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamTableMeta);
                }
                hashPropsKeys = NStreamQueryPlanBuilder.toHashKeyFuncs(indexKeyInfo.getOrderedHashDesc());
                hashIndexProps = IndexedPropDesc.getIndexProperties(indexPairFound.getFirst().getHashIndexedProps());
                rangePropsKeys = NStreamQueryPlanBuilder.toRangeKeyFuncs(indexKeyInfo.getOrderedRangeDesc());
                rangeIndexProps = IndexedPropDesc.getIndexProperties(indexPairFound.getFirst().getRangeIndexedProps());
                indexNum = new TableLookupIndexReqKey(indexPairFound.getSecond().getOptionalIndexName(), indexedStreamTableMeta.getTableName());
                if (hashIndexProps.length == 0 && rangeIndexProps.length == 0) {
                    return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamTableMeta);
                }
            } else {
                return NStreamQueryPlanBuilder.getFullTableScanTable(currentLookupStream, indexedStream, indexedStreamTableMeta);
            }
        }
        if (hashIndexProps.length > 0 && rangeIndexProps.length == 0) {
            TableLookupPlan tableLookupPlan = hashPropsKeys.size() == 1 ? new IndexedTableLookupPlanSingle(currentLookupStream, indexedStream, indexNum, hashPropsKeys.get(0)) : new IndexedTableLookupPlanMulti(currentLookupStream, indexedStream, indexNum, hashPropsKeys);
            CoercionDesc coercionTypes = CoercionUtil.getCoercionTypesHash(typesPerStream, currentLookupStream, indexedStream, hashPropsKeys, (String[])hashIndexProps);
            if (coercionTypes.isCoerce()) {
                Class[] existCoercionTypes = indexSpecs.getCoercionTypes((String[])hashIndexProps);
                if (existCoercionTypes != null) {
                    for (i = 0; i < existCoercionTypes.length; ++i) {
                        coercionTypes.getCoercionTypes()[i] = JavaClassHelper.getCompareToCoercionType(existCoercionTypes[i], coercionTypes.getCoercionTypes()[i]);
                    }
                }
                indexSpecs.setCoercionTypes((String[])hashIndexProps, coercionTypes.getCoercionTypes());
            }
            return tableLookupPlan;
        }
        if (hashIndexProps.length == 0 && rangeIndexProps.length == 1) {
            QueryGraphValueEntryRange range = rangePropsKeys.get(0);
            return new SortedTableLookupPlan(currentLookupStream, indexedStream, indexNum, range);
        }
        return new CompositeTableLookupPlan(currentLookupStream, indexedStream, indexNum, hashPropsKeys, rangePropsKeys);
    }

    protected static BestChainResult computeBestPath(int lookupStream, QueryGraph queryGraph, DependencyGraph dependencyGraph) {
        int[] defNestingorder = NStreamQueryPlanBuilder.buildDefaultNestingOrder(queryGraph.getNumStreams(), lookupStream);
        Enumeration<int[]> streamEnum = defNestingorder.length < 6 ? new NumberSetPermutationEnumeration(defNestingorder) : new NumberSetShiftGroupEnumeration(defNestingorder);
        int[] bestPermutation = null;
        int bestDepth = -1;
        while (streamEnum.hasMoreElements()) {
            boolean pass;
            int[] permutation = streamEnum.nextElement();
            if (dependencyGraph != null && !(pass = NStreamQueryPlanBuilder.isDependencySatisfied(lookupStream, permutation, dependencyGraph))) continue;
            int permutationDepth = NStreamQueryPlanBuilder.computeNavigableDepth(lookupStream, permutation, queryGraph);
            if (permutationDepth > bestDepth) {
                bestPermutation = permutation;
                bestDepth = permutationDepth;
            }
            if (permutationDepth != queryGraph.getNumStreams() - 1) continue;
            break;
        }
        return new BestChainResult(bestDepth, bestPermutation);
    }

    protected static boolean isDependencySatisfied(int lookupStream, int[] permutation, DependencyGraph dependencyGraph) {
        for (Map.Entry<Integer, SortedSet<Integer>> entry : dependencyGraph.getDependencies().entrySet()) {
            int target = entry.getKey();
            int positionTarget = NStreamQueryPlanBuilder.positionOf(target, lookupStream, permutation);
            if (positionTarget == -1) {
                throw new IllegalArgumentException("Target dependency not found in permutation for target " + target + " and permutation " + Arrays.toString(permutation) + " and lookup stream " + lookupStream);
            }
            Iterator iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                int dependency = (Integer)iterator.next();
                int positonDep = NStreamQueryPlanBuilder.positionOf(dependency, lookupStream, permutation);
                if (positonDep == -1) {
                    throw new IllegalArgumentException("Dependency not found in permutation for dependency " + dependency + " and permutation " + Arrays.toString(permutation) + " and lookup stream " + lookupStream);
                }
                if (positonDep <= positionTarget) continue;
                return false;
            }
        }
        return true;
    }

    private static int positionOf(int stream, int lookupStream, int[] permutation) {
        if (stream == lookupStream) {
            return 0;
        }
        for (int i = 0; i < permutation.length; ++i) {
            if (permutation[i] != stream) continue;
            return i + 1;
        }
        return -1;
    }

    protected static int computeNavigableDepth(int lookupStream, int[] nextStreams, QueryGraph queryGraph) {
        int nextStream;
        boolean navigable;
        int currentStream = lookupStream;
        int currentDepth = 0;
        for (int i = 0; i < nextStreams.length && (navigable = queryGraph.isNavigableAtAll(currentStream, nextStream = nextStreams[i])); ++i) {
            currentStream = nextStream;
            ++currentDepth;
        }
        return currentDepth;
    }

    protected static int[] buildDefaultNestingOrder(int numStreams, int forStream) {
        int[] nestingOrder = new int[numStreams - 1];
        int count = 0;
        for (int i = 0; i < numStreams; ++i) {
            if (i == forStream) continue;
            nestingOrder[count++] = i;
        }
        return nestingOrder;
    }

    private static List<QueryGraphValueEntryRange> toRangeKeyFuncs(List<SubordPropRangeKey> orderedRangeDesc) {
        ArrayList<QueryGraphValueEntryRange> result = new ArrayList<QueryGraphValueEntryRange>();
        for (SubordPropRangeKey key : orderedRangeDesc) {
            result.add(key.getRangeInfo());
        }
        return result;
    }

    private static List<QueryGraphValueEntryHashKeyed> toHashKeyFuncs(List<SubordPropHashKey> orderedHashProperties) {
        ArrayList<QueryGraphValueEntryHashKeyed> result = new ArrayList<QueryGraphValueEntryHashKeyed>();
        for (SubordPropHashKey key : orderedHashProperties) {
            result.add(key.getHashKey());
        }
        return result;
    }

    private static TableLookupPlan getFullTableScanTable(int lookupStream, int indexedStream, TableMetadata indexedStreamTableMeta) {
        TableLookupIndexReqKey indexName = new TableLookupIndexReqKey(indexedStreamTableMeta.getTableName(), indexedStreamTableMeta.getTableName());
        return new FullTableScanUniquePerKeyLookupPlan(lookupStream, indexedStream, indexName);
    }

    private static Set<String> toSet(String[] strings) {
        return new LinkedHashSet<String>(Arrays.asList(strings));
    }

    private static SubordPropRangeKey[] getRangeFuncsAsSubProp(List<QueryGraphValueEntryRange> funcs) {
        SubordPropRangeKey[] keys = new SubordPropRangeKey[funcs.size()];
        for (int i = 0; i < funcs.size(); ++i) {
            QueryGraphValueEntryRange func = funcs.get(i);
            keys[i] = new SubordPropRangeKey(func, func.getExpressions()[0].getExprEvaluator().getType());
        }
        return keys;
    }

    private static SubordPropHashKey[] getHashKeyFuncsAsSubProp(List<QueryGraphValueEntryHashKeyed> funcs) {
        SubordPropHashKey[] keys = new SubordPropHashKey[funcs.size()];
        for (int i = 0; i < funcs.size(); ++i) {
            keys[i] = new SubordPropHashKey(funcs.get(i), null, null);
        }
        return keys;
    }

    public static class BestChainResult {
        private int depth;
        private int[] chain;

        public BestChainResult(int depth, int[] chain) {
            this.depth = depth;
            this.chain = chain;
        }

        public int getDepth() {
            return this.depth;
        }

        public int[] getChain() {
            return this.chain;
        }

        public String toString() {
            return "depth=" + this.depth + " chain=" + Arrays.toString(this.chain);
        }
    }
}

