/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexEnterRemove;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexEnterRemoveKeyed;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexEnterRemoveRange;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.EventTableFactoryTableIdent;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.EventTableOrganizationType;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTable;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTableImpl;
import com.espertech.esper.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class PropertyCompositeEventTableFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String[] optionalKeyedProps;
    protected final String[] rangeProps;
    protected final CompositeIndexEnterRemove chain;
    protected final Class[] optKeyCoercedTypes;
    protected final Class[] optRangeCoercedTypes;

    public PropertyCompositeEventTableFactory(int streamNum, EventType eventType, String[] optionalKeyedProps, Class[] optKeyCoercedTypes, String[] rangeProps, Class[] optRangeCoercedTypes) {
        this.streamNum = streamNum;
        this.rangeProps = rangeProps;
        this.optionalKeyedProps = optionalKeyedProps;
        this.optKeyCoercedTypes = optKeyCoercedTypes;
        this.optRangeCoercedTypes = optRangeCoercedTypes;
        ArrayList<CompositeIndexEnterRemove> enterRemoves = new ArrayList<CompositeIndexEnterRemove>();
        if (optionalKeyedProps != null && optionalKeyedProps.length > 0) {
            enterRemoves.add(new CompositeIndexEnterRemoveKeyed(eventType, optionalKeyedProps, optKeyCoercedTypes));
        }
        int count = 0;
        for (String rangeProp : rangeProps) {
            Class coercionType = optRangeCoercedTypes == null ? null : optRangeCoercedTypes[count];
            enterRemoves.add(new CompositeIndexEnterRemoveRange(eventType, rangeProp, coercionType));
            ++count;
        }
        CompositeIndexEnterRemove last = null;
        for (CompositeIndexEnterRemove action : enterRemoves) {
            if (last != null) {
                last.setNext(action);
            }
            last = action;
        }
        this.chain = (CompositeIndexEnterRemove)enterRemoves.get(0);
    }

    @Override
    public EventTable[] makeEventTables(EventTableFactoryTableIdent tableIdent) {
        EventTableOrganization organization = this.getOrganization();
        return new EventTable[]{new PropertyCompositeEventTableImpl(this.optKeyCoercedTypes, this.optRangeCoercedTypes, organization, this.optionalKeyedProps != null && this.optionalKeyedProps.length > 0, this.chain)};
    }

    @Override
    public Class getEventTableClass() {
        return PropertyCompositeEventTable.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getName() + " streamNum=" + this.streamNum + " keys=" + Arrays.toString(this.optionalKeyedProps) + " ranges=" + Arrays.toString(this.rangeProps);
    }

    protected EventTableOrganization getOrganization() {
        return new EventTableOrganization(null, false, this.optKeyCoercedTypes != null || this.optRangeCoercedTypes != null, this.streamNum, this.combinedPropertyLists(this.optionalKeyedProps, this.rangeProps), EventTableOrganizationType.COMPOSITE);
    }

    private String[] combinedPropertyLists(String[] optionalKeyedProps, String[] rangeProps) {
        if (optionalKeyedProps == null) {
            return rangeProps;
        }
        if (rangeProps == null) {
            return optionalKeyedProps;
        }
        return (String[])CollectionUtil.addArrays(optionalKeyedProps, rangeProps);
    }
}

