/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.EventTableFactoryTableIdent;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.EventTableOrganizationType;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableUnadorned;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableUnique;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyIndexedEventTableFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String[] propertyNames;
    protected final boolean unique;
    protected final String optionalIndexName;
    protected final EventPropertyGetter[] propertyGetters;
    private static Logger log = LoggerFactory.getLogger(PropertyIndexedEventTableFactory.class);

    public PropertyIndexedEventTableFactory(int streamNum, EventType eventType, String[] propertyNames, boolean unique, String optionalIndexName) {
        this.streamNum = streamNum;
        this.propertyNames = propertyNames;
        this.unique = unique;
        this.optionalIndexName = optionalIndexName;
        this.propertyGetters = new EventPropertyGetter[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            this.propertyGetters[i] = eventType.getGetter(propertyNames[i]);
        }
    }

    @Override
    public EventTable[] makeEventTables(EventTableFactoryTableIdent tableIdent) {
        EventTableOrganization organization = this.getOrganization();
        if (this.unique) {
            return new EventTable[]{new PropertyIndexedEventTableUnique(this.propertyGetters, organization)};
        }
        return new EventTable[]{new PropertyIndexedEventTableUnadorned(this.propertyGetters, organization)};
    }

    @Override
    public Class getEventTableClass() {
        if (this.unique) {
            return PropertyIndexedEventTableUnique.class;
        }
        return PropertyIndexedEventTableUnadorned.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + (this.unique ? " unique" : " non-unique") + " streamNum=" + this.streamNum + " propertyNames=" + Arrays.toString(this.propertyNames);
    }

    public int getStreamNum() {
        return this.streamNum;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getOptionalIndexName() {
        return this.optionalIndexName;
    }

    public EventPropertyGetter[] getPropertyGetters() {
        return this.propertyGetters;
    }

    protected EventTableOrganization getOrganization() {
        return new EventTableOrganization(this.optionalIndexName, this.unique, false, this.streamNum, this.propertyNames, EventTableOrganizationType.HASH);
    }
}

