/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.SuperIterator;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValue;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueEquals;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueRange;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.PropertySortedEventTable;
import com.espertech.esper.epl.join.table.PropertySortedEventTableIterator;
import com.espertech.esper.filter.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class PropertySortedEventTableImpl
extends PropertySortedEventTable {
    protected final TreeMap<Object, Set<EventBean>> propertyIndex = new TreeMap();
    protected final HashSet<EventBean> nullKeyedValues = new LinkedHashSet<EventBean>();

    protected Object coerce(Object value) {
        return value;
    }

    public PropertySortedEventTableImpl(EventPropertyGetter propertyGetter, EventTableOrganization organization) {
        super(propertyGetter, organization);
    }

    @Override
    public Set<EventBean> lookupRange(Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd, boolean allowRangeReversal) {
        NavigableMap<Object, Set<EventBean>> submap;
        if (keyStart == null || keyEnd == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        try {
            submap = this.propertyIndex.subMap(keyStart, includeStart, keyEnd, includeEnd);
        }
        catch (IllegalArgumentException ex) {
            if (allowRangeReversal) {
                submap = this.propertyIndex.subMap(keyEnd, includeStart, keyStart, includeEnd);
            }
            return Collections.emptySet();
        }
        return PropertySortedEventTableImpl.normalize(submap);
    }

    @Override
    public Collection<EventBean> lookupRangeColl(Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd, boolean allowRangeReversal) {
        NavigableMap<Object, Set<EventBean>> submap;
        if (keyStart == null || keyEnd == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        try {
            submap = this.propertyIndex.subMap(keyStart, includeStart, keyEnd, includeEnd);
        }
        catch (IllegalArgumentException ex) {
            if (allowRangeReversal) {
                submap = this.propertyIndex.subMap(keyEnd, includeStart, keyStart, includeEnd);
            }
            return Collections.emptyList();
        }
        return PropertySortedEventTableImpl.normalizeCollection(submap);
    }

    @Override
    public Set<EventBean> lookupRangeInverted(Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd) {
        if (keyStart == null || keyEnd == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        NavigableMap<Object, Set<EventBean>> submapOne = this.propertyIndex.headMap(keyStart, !includeStart);
        NavigableMap<Object, Set<EventBean>> submapTwo = this.propertyIndex.tailMap(keyEnd, !includeEnd);
        return PropertySortedEventTableImpl.normalize(submapOne, submapTwo);
    }

    @Override
    public Collection<EventBean> lookupRangeInvertedColl(Object keyStart, boolean includeStart, Object keyEnd, boolean includeEnd) {
        if (keyStart == null || keyEnd == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        keyEnd = this.coerce(keyEnd);
        NavigableMap<Object, Set<EventBean>> submapOne = this.propertyIndex.headMap(keyStart, !includeStart);
        NavigableMap<Object, Set<EventBean>> submapTwo = this.propertyIndex.tailMap(keyEnd, !includeEnd);
        return PropertySortedEventTableImpl.normalizeCollection(submapOne, submapTwo);
    }

    @Override
    public Set<EventBean> lookupLess(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        return PropertySortedEventTableImpl.normalize(this.propertyIndex.headMap(keyStart));
    }

    @Override
    public Collection<EventBean> lookupLessThenColl(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        return PropertySortedEventTableImpl.normalizeCollection(this.propertyIndex.headMap(keyStart));
    }

    @Override
    public Set<EventBean> lookupLessEqual(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        return PropertySortedEventTableImpl.normalize(this.propertyIndex.headMap(keyStart, true));
    }

    @Override
    public Collection<EventBean> lookupLessEqualColl(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        return PropertySortedEventTableImpl.normalizeCollection(this.propertyIndex.headMap(keyStart, true));
    }

    @Override
    public Set<EventBean> lookupGreaterEqual(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        return PropertySortedEventTableImpl.normalize(this.propertyIndex.tailMap(keyStart));
    }

    @Override
    public Collection<EventBean> lookupGreaterEqualColl(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        return PropertySortedEventTableImpl.normalizeCollection(this.propertyIndex.tailMap(keyStart));
    }

    @Override
    public Set<EventBean> lookupGreater(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptySet();
        }
        keyStart = this.coerce(keyStart);
        return PropertySortedEventTableImpl.normalize(this.propertyIndex.tailMap(keyStart, false));
    }

    @Override
    public Collection<EventBean> lookupGreaterColl(Object keyStart) {
        if (keyStart == null) {
            return Collections.emptyList();
        }
        keyStart = this.coerce(keyStart);
        return PropertySortedEventTableImpl.normalizeCollection(this.propertyIndex.tailMap(keyStart, false));
    }

    @Override
    public Integer getNumberOfEvents() {
        return null;
    }

    @Override
    public int getNumKeys() {
        return this.propertyIndex.size();
    }

    @Override
    public Object getIndex() {
        return this.propertyIndex;
    }

    @Override
    public void add(EventBean theEvent) {
        Object key = this.getIndexedValue(theEvent);
        if ((key = this.coerce(key)) == null) {
            this.nullKeyedValues.add(theEvent);
            return;
        }
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            events = new LinkedHashSet<EventBean>();
            this.propertyIndex.put(key, events);
        }
        events.add(theEvent);
    }

    @Override
    public void remove(EventBean theEvent) {
        Object key = this.getIndexedValue(theEvent);
        if (key == null) {
            this.nullKeyedValues.remove(theEvent);
            return;
        }
        Set<EventBean> events = this.propertyIndex.get(key = this.coerce(key));
        if (events == null) {
            return;
        }
        if (!events.remove(theEvent)) {
            return;
        }
        if (events.isEmpty()) {
            this.propertyIndex.remove(key);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        if (this.nullKeyedValues.isEmpty()) {
            return new PropertySortedEventTableIterator(this.propertyIndex);
        }
        return new SuperIterator<EventBean>(new PropertySortedEventTableIterator(this.propertyIndex), this.nullKeyedValues.iterator());
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public Set<EventBean> lookupConstants(RangeIndexLookupValue lookupValueBase) {
        if (lookupValueBase instanceof RangeIndexLookupValueEquals) {
            RangeIndexLookupValueEquals equals = (RangeIndexLookupValueEquals)lookupValueBase;
            return this.propertyIndex.get(equals.getValue());
        }
        RangeIndexLookupValueRange lookupValue = (RangeIndexLookupValueRange)lookupValueBase;
        if (lookupValue.getOperator() == QueryGraphRangeEnum.RANGE_CLOSED) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRange(range.getLowEndpoint(), true, range.getHighEndpoint(), true, lookupValue.isAllowRangeReverse());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.RANGE_HALF_OPEN) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRange(range.getLowEndpoint(), true, range.getHighEndpoint(), false, lookupValue.isAllowRangeReverse());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.RANGE_HALF_CLOSED) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRange(range.getLowEndpoint(), false, range.getHighEndpoint(), true, lookupValue.isAllowRangeReverse());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.RANGE_OPEN) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRange(range.getLowEndpoint(), false, range.getHighEndpoint(), false, lookupValue.isAllowRangeReverse());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.NOT_RANGE_CLOSED) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRangeInverted(range.getLowEndpoint(), true, range.getHighEndpoint(), true);
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.NOT_RANGE_HALF_OPEN) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRangeInverted(range.getLowEndpoint(), true, range.getHighEndpoint(), false);
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.NOT_RANGE_HALF_CLOSED) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRangeInverted(range.getLowEndpoint(), false, range.getHighEndpoint(), true);
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.NOT_RANGE_OPEN) {
            Range range = (Range)lookupValue.getValue();
            return this.lookupRangeInverted(range.getLowEndpoint(), false, range.getHighEndpoint(), false);
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.GREATER) {
            return this.lookupGreater(lookupValue.getValue());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.GREATER_OR_EQUAL) {
            return this.lookupGreaterEqual(lookupValue.getValue());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.LESS) {
            return this.lookupLess(lookupValue.getValue());
        }
        if (lookupValue.getOperator() == QueryGraphRangeEnum.LESS_OR_EQUAL) {
            return this.lookupLessEqual(lookupValue.getValue());
        }
        throw new IllegalArgumentException("Unrecognized operator '" + (Object)((Object)lookupValue.getOperator()) + "'");
    }

    @Override
    public Class getProviderClass() {
        return PropertySortedEventTable.class;
    }
}

