/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.join.exec.sorted.SortedAccessStrategy;
import com.espertech.esper.epl.join.exec.sorted.SortedAccessStrategyFactory;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertySortedEventTable;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.LookupStrategyType;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import com.espertech.esper.epl.lookup.SubordSortedTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.epl.virtualdw.VirtualDWView;

public class SubordSortedTableLookupStrategyFactory
implements SubordTableLookupStrategyFactory {
    private final SubordPropRangeKey rangeKey;
    protected final SortedAccessStrategy strategy;
    protected final LookupStrategyDesc strategyDesc;

    public SubordSortedTableLookupStrategyFactory(boolean isNWOnTrigger, int numStreams, SubordPropRangeKey rangeKey) {
        this.rangeKey = rangeKey;
        this.strategy = SortedAccessStrategyFactory.make(isNWOnTrigger, -1, numStreams, rangeKey);
        this.strategyDesc = new LookupStrategyDesc(LookupStrategyType.RANGE, ExprNodeUtility.toExpressionStringsMinPrecedence(rangeKey.getRangeInfo().getExpressions()));
    }

    @Override
    public SubordTableLookupStrategy makeStrategy(EventTable[] eventTable, VirtualDWView vdw) {
        return new SubordSortedTableLookupStrategy(this.strategy, (PropertySortedEventTable)eventTable[0], this.strategyDesc);
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " range " + this.rangeKey.toQueryPlan();
    }
}

