/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.named.NamedWindowDispatchService;
import com.espertech.esper.epl.named.NamedWindowLifecycleEvent;
import com.espertech.esper.epl.named.NamedWindowLifecycleObserver;
import com.espertech.esper.epl.named.NamedWindowMgmtService;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.view.ViewProcessingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NamedWindowMgmtServiceImpl
implements NamedWindowMgmtService {
    private final Map<String, NamedWindowProcessor> processors = new HashMap<String, NamedWindowProcessor>();
    private final Map<String, NamedWindowLockPair> windowStatementLocks = new HashMap<String, NamedWindowLockPair>();
    private final Set<NamedWindowLifecycleObserver> observers = new HashSet<NamedWindowLifecycleObserver>();
    private final boolean enableQueryPlanLog;
    private final MetricReportingService metricReportingService;

    public NamedWindowMgmtServiceImpl(boolean enableQueryPlanLog, MetricReportingService metricReportingService) {
        this.enableQueryPlanLog = enableQueryPlanLog;
        this.metricReportingService = metricReportingService;
    }

    @Override
    public void destroy() {
        this.processors.clear();
    }

    @Override
    public String[] getNamedWindows() {
        Set<String> names = this.processors.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public StatementAgentInstanceLock getNamedWindowLock(String windowName) {
        NamedWindowLockPair pair = this.windowStatementLocks.get(windowName);
        if (pair == null) {
            return null;
        }
        return pair.getLock();
    }

    @Override
    public void addNamedWindowLock(String windowName, StatementAgentInstanceLock statementResourceLock, String statementName) {
        this.windowStatementLocks.put(windowName, new NamedWindowLockPair(statementName, statementResourceLock));
    }

    @Override
    public void removeNamedWindowLock(String statementName) {
        for (Map.Entry<String, NamedWindowLockPair> entry : this.windowStatementLocks.entrySet()) {
            if (!entry.getValue().getStatementName().equals(statementName)) continue;
            this.windowStatementLocks.remove(entry.getKey());
            return;
        }
    }

    @Override
    public boolean isNamedWindow(String name) {
        return this.processors.containsKey(name);
    }

    @Override
    public NamedWindowProcessor getProcessor(String name) {
        return this.processors.get(name);
    }

    @Override
    public IndexMultiKey[] getNamedWindowIndexes(String windowName) {
        NamedWindowProcessor processor = this.processors.get(windowName);
        if (processor == null) {
            return null;
        }
        return processor.getProcessorInstance(null).getIndexDescriptors();
    }

    @Override
    public void removeNamedWindowIfFound(String namedWindowName) {
        NamedWindowProcessor processor = this.processors.get(namedWindowName);
        if (processor == null) {
            return;
        }
        processor.clearProcessorInstances();
        this.removeProcessor(namedWindowName);
    }

    @Override
    public NamedWindowProcessor addProcessor(String name, String contextName, EventType eventType, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, String eplExpression, String statementName, boolean isPrioritized, boolean isEnableSubqueryIndexShare, boolean isBatchingDataWindow, boolean isVirtualDataWindow, Set<String> optionalUniqueKeyProps, String eventTypeAsName, StatementContext statementContextCreateWindow, NamedWindowDispatchService namedWindowDispatchService) throws ViewProcessingException {
        if (this.processors.containsKey(name)) {
            throw new ViewProcessingException("A named window by name '" + name + "' has already been created");
        }
        NamedWindowProcessor processor = namedWindowDispatchService.createProcessor(name, this, namedWindowDispatchService, contextName, eventType, statementResultService, revisionProcessor, eplExpression, statementName, isPrioritized, isEnableSubqueryIndexShare, this.enableQueryPlanLog, this.metricReportingService, isBatchingDataWindow, isVirtualDataWindow, optionalUniqueKeyProps, eventTypeAsName, statementContextCreateWindow);
        this.processors.put(name, processor);
        if (!this.observers.isEmpty()) {
            NamedWindowLifecycleEvent theEvent = new NamedWindowLifecycleEvent(name, processor, NamedWindowLifecycleEvent.LifecycleEventType.CREATE, new Object[0]);
            for (NamedWindowLifecycleObserver observer : this.observers) {
                observer.observe(theEvent);
            }
        }
        return processor;
    }

    @Override
    public void removeProcessor(String name) {
        NamedWindowProcessor processor = this.processors.get(name);
        if (processor != null) {
            processor.destroy();
            this.processors.remove(name);
            if (!this.observers.isEmpty()) {
                NamedWindowLifecycleEvent theEvent = new NamedWindowLifecycleEvent(name, processor, NamedWindowLifecycleEvent.LifecycleEventType.DESTROY, new Object[0]);
                for (NamedWindowLifecycleObserver observer : this.observers) {
                    observer.observe(theEvent);
                }
            }
        }
    }

    @Override
    public void addObserver(NamedWindowLifecycleObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(NamedWindowLifecycleObserver observer) {
        this.observers.remove(observer);
    }

    private static class NamedWindowLockPair {
        private final String statementName;
        private final StatementAgentInstanceLock lock;

        private NamedWindowLockPair(String statementName, StatementAgentInstanceLock lock) {
            this.statementName = statementName;
            this.lock = lock;
        }

        public String getStatementName() {
            return this.statementName;
        }

        public StatementAgentInstanceLock getLock() {
            return this.lock;
        }
    }
}

