/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.core.service.resource.StatementResourceHolder;
import com.espertech.esper.core.service.resource.StatementResourceService;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.lookup.EventTableIndexMetadata;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.epl.named.NamedWindowConsumerDesc;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDispatchService;
import com.espertech.esper.epl.named.NamedWindowMgmtService;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.named.NamedWindowTailView;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NamedWindowProcessor {
    private final String namedWindowName;
    private final NamedWindowTailView tailView;
    private final NamedWindowRootView rootView;
    private final String contextName;
    private final EventType eventType;
    private final String eplExpression;
    private final String statementName;
    private final boolean isEnableSubqueryIndexShare;
    private final boolean isVirtualDataWindow;
    private final Set<String> optionalUniqueKeyProps;
    private final String eventTypeAsName;
    private final EventTableIndexMetadata eventTableIndexMetadataRepo = new EventTableIndexMetadata();
    private final StatementContext statementContextCreateWindow;

    public NamedWindowProcessor(String namedWindowName, NamedWindowMgmtService namedWindowMgmtService, NamedWindowDispatchService namedWindowDispatchService, String contextName, EventType eventType, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, String eplExpression, String statementName, boolean isPrioritized, boolean isEnableSubqueryIndexShare, boolean enableQueryPlanLog, MetricReportingService metricReportingService, boolean isBatchingDataWindow, boolean isVirtualDataWindow, Set<String> optionalUniqueKeyProps, String eventTypeAsName, StatementContext statementContextCreateWindow) {
        this.namedWindowName = namedWindowName;
        this.contextName = contextName;
        this.eventType = eventType;
        this.eplExpression = eplExpression;
        this.statementName = statementName;
        this.isEnableSubqueryIndexShare = isEnableSubqueryIndexShare;
        this.isVirtualDataWindow = isVirtualDataWindow;
        this.optionalUniqueKeyProps = optionalUniqueKeyProps;
        this.eventTypeAsName = eventTypeAsName;
        this.statementContextCreateWindow = statementContextCreateWindow;
        this.rootView = new NamedWindowRootView(revisionProcessor, enableQueryPlanLog, metricReportingService, eventType, isBatchingDataWindow, isEnableSubqueryIndexShare, optionalUniqueKeyProps);
        this.tailView = namedWindowDispatchService.createTailView(eventType, namedWindowMgmtService, namedWindowDispatchService, statementResultService, revisionProcessor, isPrioritized, isBatchingDataWindow, contextName, statementContextCreateWindow.getTimeSourceService(), statementContextCreateWindow.getConfigSnapshot().getEngineDefaults().getThreading());
    }

    public String getEventTypeAsName() {
        return this.eventTypeAsName;
    }

    public synchronized NamedWindowProcessorInstance addInstance(AgentInstanceContext agentInstanceContext) {
        if (this.contextName == null) {
            return new NamedWindowProcessorInstance(null, this, agentInstanceContext);
        }
        int instanceId = agentInstanceContext.getAgentInstanceId();
        return new NamedWindowProcessorInstance(instanceId, this, agentInstanceContext);
    }

    public NamedWindowProcessorInstance getProcessorInstanceNoContext() {
        StatementResourceHolder holder = this.statementContextCreateWindow.getStatementExtensionServicesContext().getStmtResources().getUnpartitioned();
        return holder == null ? null : holder.getNamedWindowProcessorInstance();
    }

    public NamedWindowProcessorInstance getProcessorInstance(int agentInstanceId) {
        StatementResourceHolder holder = this.statementContextCreateWindow.getStatementExtensionServicesContext().getStmtResources().getPartitioned(agentInstanceId);
        return holder == null ? null : holder.getNamedWindowProcessorInstance();
    }

    public NamedWindowProcessorInstance getProcessorInstanceAllowUnpartitioned(int agentInstanceId) {
        if (agentInstanceId == -1) {
            return this.getProcessorInstanceNoContext();
        }
        StatementResourceHolder holder = this.statementContextCreateWindow.getStatementExtensionServicesContext().getStmtResources().getPartitioned(agentInstanceId);
        return holder == null ? null : holder.getNamedWindowProcessorInstance();
    }

    public synchronized Collection<Integer> getProcessorInstancesAll() {
        Set<Integer> keyset = this.statementContextCreateWindow.getStatementExtensionServicesContext().getStmtResources().getResourcesPartitioned().keySet();
        return new ArrayDeque<Integer>(keyset);
    }

    public NamedWindowProcessorInstance getProcessorInstance(AgentInstanceContext agentInstanceContext) {
        if (this.contextName == null) {
            return this.getProcessorInstanceNoContext();
        }
        if (agentInstanceContext.getStatementContext().getContextDescriptor() == null) {
            return null;
        }
        if (this.contextName.equals(agentInstanceContext.getStatementContext().getContextDescriptor().getContextName())) {
            return this.getProcessorInstance(agentInstanceContext.getAgentInstanceId());
        }
        return null;
    }

    public String getContextName() {
        return this.contextName;
    }

    public NamedWindowConsumerView addConsumer(NamedWindowConsumerDesc consumerDesc, boolean isSubselect) {
        StatementResourceService statementResourceService = this.statementContextCreateWindow.getStatementExtensionServicesContext().getStmtResources();
        if (this.contextName != null) {
            ContextDescriptor contextDescriptor = consumerDesc.getAgentInstanceContext().getStatementContext().getContextDescriptor();
            if (contextDescriptor != null && this.contextName.equals(contextDescriptor.getContextName())) {
                StatementResourceHolder holder = statementResourceService.getPartitioned(consumerDesc.getAgentInstanceContext().getAgentInstanceId());
                return holder.getNamedWindowProcessorInstance().getTailViewInstance().addConsumer(consumerDesc, isSubselect);
            }
            return this.tailView.addConsumer(consumerDesc);
        }
        return statementResourceService.getResourcesUnpartitioned().getNamedWindowProcessorInstance().getTailViewInstance().addConsumer(consumerDesc, isSubselect);
    }

    public boolean isVirtualDataWindow() {
        return this.isVirtualDataWindow;
    }

    public NamedWindowTailView getTailView() {
        return this.tailView;
    }

    public NamedWindowRootView getRootView() {
        return this.rootView;
    }

    public EventType getNamedWindowType() {
        return this.eventType;
    }

    public String getEplExpression() {
        return this.eplExpression;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public void destroy() {
    }

    public boolean isEnableSubqueryIndexShare() {
        return this.isEnableSubqueryIndexShare;
    }

    public StatementMetricHandle getCreateNamedWindowMetricsHandle() {
        return this.statementContextCreateWindow.getEpStatementHandle().getMetricsHandle();
    }

    public String getNamedWindowName() {
        return this.namedWindowName;
    }

    public String[][] getUniqueIndexes() {
        ArrayList<String[]> unique = null;
        Set<IndexMultiKey> indexDescriptors = this.getEventTableIndexMetadataRepo().getIndexes().keySet();
        for (IndexMultiKey index : indexDescriptors) {
            if (!index.isUnique()) continue;
            String[] uniqueKeys = IndexedPropDesc.getIndexProperties(index.getHashIndexedProps());
            if (unique == null) {
                unique = new ArrayList();
            }
            unique.add(uniqueKeys);
        }
        if (this.optionalUniqueKeyProps != null) {
            if (unique == null) {
                unique = new ArrayList<String[]>();
            }
            unique.add(this.optionalUniqueKeyProps.toArray(new String[this.optionalUniqueKeyProps.size()]));
        }
        if (unique == null) {
            return null;
        }
        return (String[][])unique.toArray((T[])new String[unique.size()][]);
    }

    public Set<String> getOptionalUniqueKeyProps() {
        return this.optionalUniqueKeyProps;
    }

    public EventTableIndexMetadata getEventTableIndexMetadataRepo() {
        return this.eventTableIndexMetadataRepo;
    }

    public StatementContext getStatementContextCreateWindow() {
        return this.statementContextCreateWindow;
    }

    public void removeAllInstanceIndexes(IndexMultiKey index) {
        StatementResourceService statementResourceService = this.statementContextCreateWindow.getStatementExtensionServicesContext().getStmtResources();
        if (this.contextName == null) {
            StatementResourceHolder holder = statementResourceService.getUnpartitioned();
            if (holder != null && holder.getNamedWindowProcessorInstance() != null) {
                holder.getNamedWindowProcessorInstance().removeIndex(index);
            }
        } else {
            for (Map.Entry<Integer, StatementResourceHolder> entry : statementResourceService.getResourcesPartitioned().entrySet()) {
                if (entry.getValue().getNamedWindowProcessorInstance() == null) continue;
                entry.getValue().getNamedWindowProcessorInstance().removeIndex(index);
            }
        }
    }

    public void validateAddIndex(String statementName, String indexName, IndexMultiKey imk) throws ExprValidationException {
        this.eventTableIndexMetadataRepo.addIndex(false, imk, indexName, statementName, true, null);
    }

    public void removeIndexReferencesStmtMayRemoveIndex(IndexMultiKey imk, String finalStatementName) {
        boolean last = this.eventTableIndexMetadataRepo.removeIndexReference(imk, finalStatementName);
        if (last) {
            this.eventTableIndexMetadataRepo.removeIndex(imk);
            this.removeAllInstanceIndexes(imk);
        }
    }

    public void clearProcessorInstances() {
        if (this.contextName == null) {
            NamedWindowProcessorInstance instance = this.getProcessorInstanceNoContext();
            if (instance != null) {
                instance.destroy();
            }
            return;
        }
        Collection<Integer> cpids = this.getProcessorInstancesAll();
        Iterator<Integer> iterator = cpids.iterator();
        if (iterator.hasNext()) {
            int cpid = iterator.next();
            NamedWindowProcessorInstance instance = this.getProcessorInstance(cpid);
            if (instance != null) {
                instance.destroy();
            }
            return;
        }
    }
}

