/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.core.ExprIdentNodeImpl;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprVariableNodeImpl;
import com.espertech.esper.epl.expression.ops.ExprEqualsNodeImpl;
import com.espertech.esper.epl.expression.ops.ExprMathNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimePeriodImpl;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableServiceUtil;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.rowregex.RowRegexExprNode;
import com.espertech.esper.type.MathArithTypeEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;

public class ASTExprHelper {
    public static ExprNode resolvePropertyOrVariableIdentifier(String identifier, VariableService variableService, StatementSpecRaw spec) {
        VariableMetaData metaData = variableService.getVariableMetaData(identifier);
        if (metaData != null) {
            ExprVariableNodeImpl exprNode = new ExprVariableNodeImpl(metaData, null);
            spec.setHasVariables(true);
            ASTExprHelper.addVariableReference(spec, metaData.getVariableName());
            String message = VariableServiceUtil.checkVariableContextName(spec.getOptionalContextName(), metaData);
            if (message != null) {
                throw ASTWalkException.from(message);
            }
            return exprNode;
        }
        return new ExprIdentNodeImpl(identifier);
    }

    public static void addVariableReference(StatementSpecRaw statementSpec, String variableName) {
        if (statementSpec.getReferencedVariables() == null) {
            statementSpec.setReferencedVariables(new HashSet<String>());
        }
        statementSpec.getReferencedVariables().add(variableName);
    }

    public static ExprTimePeriod timePeriodGetExprAllParams(EsperEPL2GrammarParser.TimePeriodContext ctx, Map<Tree, ExprNode> astExprNodeMap, VariableService variableService, StatementSpecRaw spec, ConfigurationInformation config, TimeAbacus timeAbacus) {
        ExprNode[] nodes = new ExprNode[9];
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ExprNode valueExpr;
            ParseTree unitRoot = ctx.getChild(i);
            if (ASTUtil.isTerminatedOfType((Tree)unitRoot.getChild(0), 195)) {
                String ident = unitRoot.getChild(0).getText();
                valueExpr = ASTExprHelper.resolvePropertyOrVariableIdentifier(ident, variableService, spec);
            } else {
                final AtomicReference ref = new AtomicReference();
                ExprAction action = new ExprAction(){

                    @Override
                    public void found(ExprNode exprNode, Map<Tree, ExprNode> astExprNodeMap, Tree node) {
                        astExprNodeMap.remove(node);
                        ref.set(exprNode);
                    }
                };
                ASTExprHelper.recursiveFindRemoveChildExprNode((Tree)unitRoot.getChild(0), astExprNodeMap, action);
                valueExpr = (ExprNode)ref.get();
            }
            if (ASTUtil.getRuleIndexIfProvided(unitRoot) == 239) {
                nodes[8] = valueExpr;
            }
            if (ASTUtil.getRuleIndexIfProvided(unitRoot) == 238) {
                nodes[7] = valueExpr;
            }
            if (ASTUtil.getRuleIndexIfProvided(unitRoot) == 237) {
                nodes[6] = valueExpr;
            }
            if (ASTUtil.getRuleIndexIfProvided(unitRoot) == 236) {
                nodes[5] = valueExpr;
            }
            if (ASTUtil.getRuleIndexIfProvided(unitRoot) == 235) {
                nodes[4] = valueExpr;
            }
            if (ASTUtil.getRuleIndexIfProvided(unitRoot) == 234) {
                nodes[3] = valueExpr;
            }
            if (ASTUtil.getRuleIndexIfProvided(unitRoot) == 233) {
                nodes[2] = valueExpr;
            }
            if (ASTUtil.getRuleIndexIfProvided(unitRoot) == 232) {
                nodes[1] = valueExpr;
            }
            if (ASTUtil.getRuleIndexIfProvided(unitRoot) != 231) continue;
            nodes[0] = valueExpr;
        }
        ExprTimePeriodImpl timeNode = new ExprTimePeriodImpl(config.getEngineDefaults().getExpression().getTimeZone(), nodes[0] != null, nodes[1] != null, nodes[2] != null, nodes[3] != null, nodes[4] != null, nodes[5] != null, nodes[6] != null, nodes[7] != null, nodes[8] != null, timeAbacus);
        for (ExprNode node : nodes) {
            if (node == null) continue;
            timeNode.addChildNode(node);
        }
        return timeNode;
    }

    public static ExprTimePeriod timePeriodGetExprJustSeconds(EsperEPL2GrammarParser.ExpressionContext expression, Map<Tree, ExprNode> astExprNodeMap, ConfigurationInformation config, TimeAbacus timeAbacus) {
        ExprNode node = ASTExprHelper.exprCollectSubNodes((Tree)expression, 0, astExprNodeMap).get(0);
        ExprTimePeriodImpl timeNode = new ExprTimePeriodImpl(config.getEngineDefaults().getExpression().getTimeZone(), false, false, false, false, false, false, true, false, false, timeAbacus);
        timeNode.addChildNode(node);
        return timeNode;
    }

    protected static List<OnTriggerSetAssignment> getOnTriggerSetAssignments(EsperEPL2GrammarParser.OnSetAssignmentListContext ctx, Map<Tree, ExprNode> astExprNodeMap) {
        if (ctx == null || ctx.onSetAssignment().isEmpty()) {
            return Collections.emptyList();
        }
        List<EsperEPL2GrammarParser.OnSetAssignmentContext> ctxs = ctx.onSetAssignment();
        ArrayList<OnTriggerSetAssignment> assignments = new ArrayList<OnTriggerSetAssignment>(ctx.onSetAssignment().size());
        for (EsperEPL2GrammarParser.OnSetAssignmentContext assign : ctxs) {
            ExprNode childEvalNode;
            if (assign.eventProperty() != null) {
                ExprNode prop = ASTExprHelper.exprCollectSubNodes((Tree)assign.eventProperty(), 0, astExprNodeMap).get(0);
                ExprNode value = ASTExprHelper.exprCollectSubNodes((Tree)assign.expression(), 0, astExprNodeMap).get(0);
                ExprEqualsNodeImpl equals = new ExprEqualsNodeImpl(false, false);
                equals.addChildNode(prop);
                equals.addChildNode(value);
                childEvalNode = equals;
            } else {
                childEvalNode = ASTExprHelper.exprCollectSubNodes((Tree)assign, 0, astExprNodeMap).get(0);
            }
            assignments.add(new OnTriggerSetAssignment(childEvalNode));
        }
        return assignments;
    }

    public static void patternCollectAddSubnodesAddParentNode(EvalFactoryNode evalNode, Tree node, Map<Tree, EvalFactoryNode> astPatternNodeMap) {
        if (evalNode == null) {
            throw ASTWalkException.from("Invalid null expression node for '" + ASTUtil.printNode(node) + "'");
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree childNode = node.getChild(i);
            EvalFactoryNode childEvalNode = ASTExprHelper.patternGetRemoveTopNode(childNode, astPatternNodeMap);
            if (childEvalNode == null) continue;
            evalNode.addChildNode(childEvalNode);
        }
        astPatternNodeMap.put(node, evalNode);
    }

    public static EvalFactoryNode patternGetRemoveTopNode(Tree node, Map<Tree, EvalFactoryNode> astPatternNodeMap) {
        EvalFactoryNode pattern = astPatternNodeMap.get(node);
        if (pattern != null) {
            astPatternNodeMap.remove(node);
            return pattern;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            pattern = ASTExprHelper.patternGetRemoveTopNode(node.getChild(i), astPatternNodeMap);
            if (pattern == null) continue;
            return pattern;
        }
        return null;
    }

    public static void regExCollectAddSubNodesAddParentNode(RowRegexExprNode exprNode, Tree node, Map<Tree, RowRegexExprNode> astRegExNodeMap) {
        ASTExprHelper.regExCollectAddSubNodes(exprNode, node, astRegExNodeMap);
        astRegExNodeMap.put(node, exprNode);
    }

    public static void regExCollectAddSubNodes(final RowRegexExprNode regexNode, Tree node, Map<Tree, RowRegexExprNode> astRegExNodeMap) {
        if (regexNode == null) {
            throw ASTWalkException.from("Invalid null expression node for '" + ASTUtil.printNode(node) + "'");
        }
        RegExAction action = new RegExAction(){

            @Override
            public void found(RowRegexExprNode exprNode, Map<Tree, RowRegexExprNode> astRegExNodeMap, Tree node) {
                astRegExNodeMap.remove(node);
                regexNode.addChildNode(exprNode);
            }
        };
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree childNode = node.getChild(i);
            ASTExprHelper.regExApplyActionRecursive(childNode, astRegExNodeMap, action);
        }
    }

    public static void regExApplyActionRecursive(Tree node, Map<Tree, RowRegexExprNode> astRegExNodeMap, RegExAction action) {
        RowRegexExprNode expr = astRegExNodeMap.get(node);
        if (expr != null) {
            action.found(expr, astRegExNodeMap, node);
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTExprHelper.regExApplyActionRecursive(node.getChild(i), astRegExNodeMap, action);
        }
    }

    public static void exprCollectAddSubNodesAddParentNode(ExprNode exprNode, Tree node, Map<Tree, ExprNode> astExprNodeMap) {
        ASTExprHelper.exprCollectAddSubNodes(exprNode, node, astExprNodeMap);
        astExprNodeMap.put(node, exprNode);
    }

    public static void exprCollectAddSubNodes(final ExprNode parentNode, Tree node, Map<Tree, ExprNode> astExprNodeMap) {
        if (parentNode == null) {
            throw ASTWalkException.from("Invalid null expression node for '" + ASTUtil.printNode(node) + "'");
        }
        if (node == null) {
            return;
        }
        ExprAction action = new ExprAction(){

            @Override
            public void found(ExprNode exprNode, Map<Tree, ExprNode> astExprNodeMap, Tree node) {
                astExprNodeMap.remove(node);
                parentNode.addChildNode(exprNode);
            }
        };
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree childNode = node.getChild(i);
            ASTExprHelper.recursiveFindRemoveChildExprNode(childNode, astExprNodeMap, action);
        }
    }

    public static void exprCollectAddSingle(final ExprNode parentNode, Tree node, Map<Tree, ExprNode> astExprNodeMap) {
        if (parentNode == null) {
            throw ASTWalkException.from("Invalid null expression node for '" + ASTUtil.printNode(node) + "'");
        }
        if (node == null) {
            return;
        }
        ExprAction action = new ExprAction(){

            @Override
            public void found(ExprNode exprNode, Map<Tree, ExprNode> astExprNodeMap, Tree node) {
                astExprNodeMap.remove(node);
                parentNode.addChildNode(exprNode);
            }
        };
        ASTExprHelper.recursiveFindRemoveChildExprNode(node, astExprNodeMap, action);
    }

    public static void exprCollectAddSubNodesExpressionCtx(final ExprNode parentNode, List<EsperEPL2GrammarParser.ExpressionContext> expressionContexts, Map<Tree, ExprNode> astExprNodeMap) {
        ExprAction action = new ExprAction(){

            @Override
            public void found(ExprNode exprNode, Map<Tree, ExprNode> astExprNodeMap, Tree node) {
                astExprNodeMap.remove(node);
                parentNode.addChildNode(exprNode);
            }
        };
        for (EsperEPL2GrammarParser.ExpressionContext ctx : expressionContexts) {
            ASTExprHelper.recursiveFindRemoveChildExprNode((Tree)ctx, astExprNodeMap, action);
        }
    }

    public static List<ExprNode> exprCollectSubNodes(Tree parentNode, int startIndex, Map<Tree, ExprNode> astExprNodeMap) {
        ExprNode selfNode = astExprNodeMap.remove(parentNode);
        if (selfNode != null) {
            return Collections.singletonList(selfNode);
        }
        final ArrayList<ExprNode> exprNodes = new ArrayList<ExprNode>();
        ExprAction action = new ExprAction(){

            @Override
            public void found(ExprNode exprNode, Map<Tree, ExprNode> astExprNodeMap, Tree node) {
                astExprNodeMap.remove(node);
                exprNodes.add(exprNode);
            }
        };
        for (int i = startIndex; i < parentNode.getChildCount(); ++i) {
            Tree currentNode = parentNode.getChild(i);
            ASTExprHelper.recursiveFindRemoveChildExprNode(currentNode, astExprNodeMap, action);
        }
        return exprNodes;
    }

    private static void recursiveFindRemoveChildExprNode(Tree node, Map<Tree, ExprNode> astExprNodeMap, ExprAction action) {
        ExprNode expr = astExprNodeMap.get(node);
        if (expr != null) {
            action.found(expr, astExprNodeMap, node);
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTExprHelper.recursiveFindRemoveChildExprNode(node.getChild(i), astExprNodeMap, action);
        }
    }

    public static RowRegexExprNode regExGetRemoveTopNode(Tree node, Map<Tree, RowRegexExprNode> astRowRegexNodeMap) {
        RowRegexExprNode regex = astRowRegexNodeMap.get(node);
        if (regex != null) {
            astRowRegexNodeMap.remove(node);
            return regex;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            regex = ASTExprHelper.regExGetRemoveTopNode(node.getChild(i), astRowRegexNodeMap);
            if (regex == null) continue;
            return regex;
        }
        return null;
    }

    public static ExprNode mathGetExpr(ParseTree ctx, Map<Tree, ExprNode> astExprNodeMap, ConfigurationInformation configurationInformation) {
        int count = 1;
        ExprNode base = ASTExprHelper.exprCollectSubNodes((Tree)ctx.getChild(0), 0, astExprNodeMap).get(0);
        do {
            int token = ASTUtil.getAssertTerminatedTokenType(ctx.getChild(count));
            MathArithTypeEnum mathArithTypeEnum = ASTExprHelper.tokenToMathEnum(token);
            ExprNode right = ASTExprHelper.exprCollectSubNodes((Tree)ctx.getChild(count + 1), 0, astExprNodeMap).get(0);
            ExprMathNode math = new ExprMathNode(mathArithTypeEnum, configurationInformation.getEngineDefaults().getExpression().isIntegerDivision(), configurationInformation.getEngineDefaults().getExpression().isDivisionByZeroReturnsNull());
            math.addChildNode(base);
            math.addChildNode(right);
            base = math;
        } while ((count += 2) < ctx.getChildCount());
        return base;
    }

    private static MathArithTypeEnum tokenToMathEnum(int token) {
        switch (token) {
            case 156: {
                return MathArithTypeEnum.DIVIDE;
            }
            case 164: {
                return MathArithTypeEnum.MULTIPLY;
            }
            case 158: {
                return MathArithTypeEnum.ADD;
            }
            case 161: {
                return MathArithTypeEnum.SUBTRACT;
            }
            case 166: {
                return MathArithTypeEnum.MODULO;
            }
        }
        throw ASTWalkException.from("Encountered unrecognized math token type " + token);
    }

    public static void addOptionalNumber(ExprNode exprNode, EsperEPL2GrammarParser.NumberContext number) {
        if (number == null) {
            return;
        }
        ExprConstantNodeImpl constantNode = new ExprConstantNodeImpl(ASTConstantHelper.parse((ParseTree)number));
        exprNode.addChildNode(constantNode);
    }

    public static void addOptionalSimpleProperty(ExprNode exprNode, Token token, VariableService variableService, StatementSpecRaw spec) {
        if (token == null) {
            return;
        }
        ExprNode node = ASTExprHelper.resolvePropertyOrVariableIdentifier(token.getText(), variableService, spec);
        exprNode.addChildNode(node);
    }

    public static ExprNode[] exprCollectSubNodesPerNode(List<EsperEPL2GrammarParser.ExpressionContext> expression, Map<Tree, ExprNode> astExprNodeMap) {
        ExprNode[] nodes = new ExprNode[expression.size()];
        for (int i = 0; i < expression.size(); ++i) {
            nodes[i] = ASTExprHelper.exprCollectSubNodes((Tree)expression.get(i), 0, astExprNodeMap).get(0);
        }
        return nodes;
    }

    private static interface RegExAction {
        public void found(RowRegexExprNode var1, Map<Tree, RowRegexExprNode> var2, Tree var3);
    }

    private static interface ExprAction {
        public void found(ExprNode var1, Map<Tree, ExprNode> var2, Tree var3);
    }
}

