/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.script;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.script.ExprNodeScriptEvalBase;
import com.espertech.esper.epl.script.ExprNodeScriptEvaluator;
import com.espertech.esper.epl.script.mvel.MVELInvoker;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNodeScriptEvalMVEL
extends ExprNodeScriptEvalBase
implements ExprNodeScriptEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExprNodeScriptEvalMVEL.class);
    private final Object executable;

    public ExprNodeScriptEvalMVEL(String scriptName, String statementName, String[] names, ExprEvaluator[] parameters, Class returnType, EventType eventTypeCollection, Object executable) {
        super(scriptName, statementName, names, parameters, returnType, eventTypeCollection);
        this.executable = executable;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Map<String, Object> paramsList = this.getParamsList(context);
        for (int i = 0; i < this.names.length; ++i) {
            paramsList.put(this.names[i], this.parameters[i].evaluate(eventsPerStream, isNewData, context));
        }
        return this.evaluateInternal(paramsList);
    }

    @Override
    public Object evaluate(Object[] lookupValues, ExprEvaluatorContext context) {
        Map<String, Object> paramsList = this.getParamsList(context);
        for (int i = 0; i < this.names.length; ++i) {
            paramsList.put(this.names[i], lookupValues[i]);
        }
        return this.evaluateInternal(paramsList);
    }

    private Map<String, Object> getParamsList(ExprEvaluatorContext context) {
        HashMap<String, Object> paramsList = new HashMap<String, Object>();
        paramsList.put("epl", context.getAllocateAgentInstanceScriptContext());
        return paramsList;
    }

    private Object evaluateInternal(Map<String, Object> paramsList) {
        try {
            Object result = MVELInvoker.executeExpression(this.executable, paramsList);
            if (this.coercer != null) {
                return this.coercer.coerceBoxed((Number)result);
            }
            return result;
        }
        catch (InvocationTargetException ex) {
            Throwable mvelException = ex.getCause();
            String message = "Unexpected exception executing script '" + this.scriptName + "' for statement '" + this.statementName + "' : " + mvelException.getMessage();
            log.error(message, mvelException);
            throw new EPException(message, ex);
        }
    }
}

