/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationPlugInPatternObject;
import com.espertech.esper.client.ConfigurationPlugInView;
import com.espertech.esper.client.ConfigurationPlugInVirtualDataWindow;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.spec.PluggableObjectEntry;
import com.espertech.esper.epl.spec.PluggableObjectType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluggableObjectCollection {
    private Map<String, Map<String, Pair<Class, PluggableObjectEntry>>> pluggables = new HashMap<String, Map<String, Pair<Class, PluggableObjectEntry>>>();

    public void addViews(List<ConfigurationPlugInView> configurationPlugInViews, List<ConfigurationPlugInVirtualDataWindow> configurationPlugInVirtualDW, EngineImportService engineImportService) throws ConfigurationException {
        this.initViews(configurationPlugInViews, engineImportService);
        this.initVirtualDW(configurationPlugInVirtualDW, engineImportService);
    }

    public void addPatternObjects(List<ConfigurationPlugInPatternObject> configPattern, EngineImportService engineImportService) throws ConfigurationException {
        this.initPatterns(configPattern, engineImportService);
    }

    public void addObjects(PluggableObjectCollection other) {
        for (Map.Entry<String, Map<String, Pair<Class, PluggableObjectEntry>>> entry : other.getPluggables().entrySet()) {
            Map<String, Pair<Class, PluggableObjectEntry>> namespaceMap = this.pluggables.get(entry.getKey());
            if (namespaceMap == null) {
                namespaceMap = new HashMap<String, Pair<Class, PluggableObjectEntry>>();
                this.pluggables.put(entry.getKey(), namespaceMap);
            }
            for (String name : entry.getValue().keySet()) {
                if (!namespaceMap.containsKey(name)) continue;
                throw new ConfigurationException("Duplicate object detected in namespace '" + entry.getKey() + "' by name '" + name + "'");
            }
            namespaceMap.putAll(entry.getValue());
        }
    }

    public void addObject(String namespace, String name, Class clazz, PluggableObjectType type) {
        this.addObject(namespace, name, clazz, type, null);
    }

    public void addObject(String namespace, String name, Class clazz, PluggableObjectType type, Serializable configuration) {
        Map<String, Pair<Class, PluggableObjectEntry>> namespaceMap = this.pluggables.get(namespace);
        if (namespaceMap == null) {
            namespaceMap = new HashMap<String, Pair<Class, PluggableObjectEntry>>();
            this.pluggables.put(namespace, namespaceMap);
        }
        namespaceMap.put(name, new Pair<Class, PluggableObjectEntry>(clazz, new PluggableObjectEntry(type, configuration)));
    }

    public Map<String, Map<String, Pair<Class, PluggableObjectEntry>>> getPluggables() {
        return this.pluggables;
    }

    private void initViews(List<ConfigurationPlugInView> configurationPlugInViews, EngineImportService engineImportService) {
        if (configurationPlugInViews == null) {
            return;
        }
        for (ConfigurationPlugInView entry : configurationPlugInViews) {
            this.handleAddPluggableObject(entry.getFactoryClassName(), entry.getNamespace(), entry.getName(), PluggableObjectType.VIEW, null, engineImportService);
        }
    }

    private void initVirtualDW(List<ConfigurationPlugInVirtualDataWindow> configurationPlugInVirtualDataWindows, EngineImportService engineImportService) {
        if (configurationPlugInVirtualDataWindows == null) {
            return;
        }
        for (ConfigurationPlugInVirtualDataWindow entry : configurationPlugInVirtualDataWindows) {
            this.handleAddPluggableObject(entry.getFactoryClassName(), entry.getNamespace(), entry.getName(), PluggableObjectType.VIRTUALDW, entry.getConfig(), engineImportService);
        }
    }

    private void handleAddPluggableObject(String factoryClassName, String namespace, String name, PluggableObjectType type, Serializable optionalCustomConfig, EngineImportService engineImportService) {
        Class clazz;
        if (factoryClassName == null) {
            throw new ConfigurationException("Factory class name has not been supplied for object '" + name + "'");
        }
        if (namespace == null) {
            throw new ConfigurationException("Namespace name has not been supplied for object '" + name + "'");
        }
        if (name == null) {
            throw new ConfigurationException("Name has not been supplied for object in namespace '" + namespace + "'");
        }
        try {
            clazz = engineImportService.getClassForNameProvider().classForName(factoryClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException("View factory class " + factoryClassName + " could not be loaded");
        }
        Map<String, Pair<Class, PluggableObjectEntry>> namespaceMap = this.pluggables.get(namespace);
        if (namespaceMap == null) {
            namespaceMap = new HashMap<String, Pair<Class, PluggableObjectEntry>>();
            this.pluggables.put(namespace, namespaceMap);
        }
        namespaceMap.put(name, new Pair<Class, PluggableObjectEntry>(clazz, new PluggableObjectEntry(type, optionalCustomConfig)));
    }

    private void initPatterns(List<ConfigurationPlugInPatternObject> configEntries, EngineImportService engineImportService) throws ConfigurationException {
        if (configEntries == null) {
            return;
        }
        for (ConfigurationPlugInPatternObject entry : configEntries) {
            PluggableObjectType typeEnum;
            if (entry.getPatternObjectType() == null) {
                throw new ConfigurationException("Pattern object type has not been supplied for object '" + entry.getName() + "'");
            }
            if (entry.getPatternObjectType() == ConfigurationPlugInPatternObject.PatternObjectType.GUARD) {
                typeEnum = PluggableObjectType.PATTERN_GUARD;
            } else if (entry.getPatternObjectType() == ConfigurationPlugInPatternObject.PatternObjectType.OBSERVER) {
                typeEnum = PluggableObjectType.PATTERN_OBSERVER;
            } else {
                throw new IllegalArgumentException("Pattern object type '" + (Object)((Object)entry.getPatternObjectType()) + "' not known");
            }
            this.handleAddPluggableObject(entry.getFactoryClassName(), entry.getNamespace(), entry.getName(), typeEnum, null, engineImportService);
        }
    }
}

