/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.mgmt;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.SingleEventIterable;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.access.AggregationServicePassThru;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.EventTableOrganizationType;
import com.espertech.esper.epl.join.table.SingleReferenceEventTable;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.mgmt.TableStateInstanceUngrouped;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

public class TableStateInstanceUngroupedImpl
extends TableStateInstance
implements TableStateInstanceUngrouped,
Iterable<EventBean> {
    private AtomicReference<ObjectArrayBackedEventBean> eventReference = new AtomicReference<Object>(null);

    public TableStateInstanceUngroupedImpl(TableMetadata tableMetadata, AgentInstanceContext agentInstanceContext) {
        super(tableMetadata, agentInstanceContext);
    }

    @Override
    public Iterable<EventBean> getIterableTableScan() {
        return new SingleEventIterable(this.eventReference);
    }

    @Override
    public void addEvent(EventBean theEvent) {
        if (this.eventReference.get() != null) {
            throw new EPException("Unique index violation, table '" + this.tableMetadata.getTableName() + "' is a declared to hold a single un-keyed row");
        }
        this.eventReference.set((ObjectArrayBackedEventBean)theEvent);
    }

    @Override
    public void deleteEvent(EventBean matchingEvent) {
        this.eventReference.set(null);
    }

    public AtomicReference<ObjectArrayBackedEventBean> getEventReference() {
        return this.eventReference;
    }

    @Override
    public ObjectArrayBackedEventBean getEventUngrouped() {
        return this.eventReference.get();
    }

    @Override
    public void addExplicitIndex(CreateIndexDesc spec, boolean isRecoveringResilient, boolean allowIndexExists) throws ExprValidationException {
        throw new ExprValidationException("Tables without primary key column(s) do not allow creating an index");
    }

    @Override
    public EventTable getIndex(String indexName) {
        if (indexName.equals(this.tableMetadata.getTableName())) {
            EventTableOrganization org = new EventTableOrganization(this.tableMetadata.getTableName(), true, false, 0, new String[0], EventTableOrganizationType.UNORGANIZED);
            return new SingleReferenceEventTable(org, this.eventReference);
        }
        throw new IllegalStateException("Invalid index requested '" + indexName + "'");
    }

    @Override
    public String[] getSecondaryIndexes() {
        return new String[0];
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.eventReference.get());
    }

    @Override
    public void clearInstance() {
        this.clearEvents();
    }

    @Override
    public void destroyInstance() {
        this.clearEvents();
    }

    @Override
    public Collection<EventBean> getEventCollection() {
        EventBean event = this.eventReference.get();
        if (event == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(event);
    }

    @Override
    public int getRowCount() {
        return this.eventReference.get() == null ? 0 : 1;
    }

    @Override
    public ObjectArrayBackedEventBean getCreateRowIntoTable(Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        ObjectArrayBackedEventBean bean = this.eventReference.get();
        if (bean != null) {
            return bean;
        }
        ObjectArrayBackedEventBean row = this.tableMetadata.getRowFactory().makeOA(exprEvaluatorContext.getAgentInstanceId(), groupByKey, null, this.getAggregationServicePassThru());
        this.addEvent(row);
        return row;
    }

    @Override
    public AggregationServicePassThru getAggregationServicePassThru() {
        return null;
    }

    private void clearEvents() {
        this.eventReference.set(null);
    }
}

