/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.mgmt;

import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.access.AggregationServicePassThru;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggSvcGroupByUtil;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationRowPair;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventType;

public class TableStateRowFactory {
    private final ObjectArrayEventType objectArrayEventType;
    private final EngineImportService engineImportService;
    private final AggregationMethodFactory[] methodFactories;
    private final AggregationStateFactory[] stateFactories;
    private final int[] groupKeyIndexes;
    private final EventAdapterService eventAdapterService;

    public TableStateRowFactory(ObjectArrayEventType objectArrayEventType, EngineImportService engineImportService, AggregationMethodFactory[] methodFactories, AggregationStateFactory[] stateFactories, int[] groupKeyIndexes, EventAdapterService eventAdapterService) {
        this.objectArrayEventType = objectArrayEventType;
        this.engineImportService = engineImportService;
        this.methodFactories = methodFactories;
        this.stateFactories = stateFactories;
        this.groupKeyIndexes = groupKeyIndexes;
        this.eventAdapterService = eventAdapterService;
    }

    public ObjectArrayBackedEventBean makeOA(int agentInstanceId, Object groupByKey, Object groupKeyBinding, AggregationServicePassThru passThru) {
        AggregationRowPair row = this.makeAggs(agentInstanceId, groupByKey, groupKeyBinding, passThru);
        Object[] data = new Object[this.objectArrayEventType.getPropertyDescriptors().length];
        data[0] = row;
        if (this.groupKeyIndexes.length == 1) {
            data[this.groupKeyIndexes[0]] = groupByKey;
        } else if (this.groupKeyIndexes.length > 1) {
            Object[] keys = ((MultiKeyUntyped)groupByKey).getKeys();
            for (int i = 0; i < this.groupKeyIndexes.length; ++i) {
                data[this.groupKeyIndexes[i]] = keys[i];
            }
        }
        return (ObjectArrayBackedEventBean)this.eventAdapterService.adapterForType(data, this.objectArrayEventType);
    }

    public AggregationRowPair makeAggs(int agentInstanceId, Object groupByKey, Object groupKeyBinding, AggregationServicePassThru passThru) {
        AggregationMethod[] methods = AggSvcGroupByUtil.newAggregators(this.methodFactories);
        AggregationState[] states = AggSvcGroupByUtil.newAccesses(agentInstanceId, false, this.stateFactories, groupByKey, passThru);
        return new AggregationRowPair(methods, states);
    }
}

