/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionBase;
import com.espertech.esper.epl.view.OutputConditionFactory;

public class OutputConditionFirst
extends OutputConditionBase
implements OutputCondition {
    private final OutputCondition innerCondition;
    private boolean witnessedFirst;

    public OutputConditionFirst(OutputCallback outputCallback, AgentInstanceContext agentInstanceContext, OutputConditionFactory innerConditionFactory) {
        super(outputCallback);
        OutputCallback localCallback = this.createCallbackToLocal();
        this.innerCondition = innerConditionFactory.make(agentInstanceContext, localCallback);
        this.witnessedFirst = false;
    }

    @Override
    public void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (!this.witnessedFirst) {
            this.witnessedFirst = true;
            boolean doOutput = true;
            boolean forceUpdate = false;
            this.outputCallback.continueOutputProcessing(doOutput, forceUpdate);
        }
        this.innerCondition.updateOutputCondition(newEventsCount, oldEventsCount);
    }

    private OutputCallback createCallbackToLocal() {
        return new OutputCallback(){

            @Override
            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputConditionFirst.this.continueOutputProcessing(forceUpdate);
            }
        };
    }

    @Override
    public void terminated() {
        this.outputCallback.continueOutputProcessing(true, true);
    }

    @Override
    public void stop() {
    }

    private void continueOutputProcessing(boolean forceUpdate) {
        boolean doOutput = !this.witnessedFirst;
        this.outputCallback.continueOutputProcessing(doOutput, forceUpdate);
        this.witnessedFirst = false;
    }
}

