/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.view.OutputProcessViewAfterState;
import java.util.Set;

public class OutputProcessViewAfterStateImpl
implements OutputProcessViewAfterState {
    private final Long afterConditionTime;
    private final Integer afterConditionNumberOfEvents;
    protected boolean isAfterConditionSatisfied;
    private int afterConditionEventsFound;

    public OutputProcessViewAfterStateImpl(Long afterConditionTime, Integer afterConditionNumberOfEvents) {
        this.afterConditionTime = afterConditionTime;
        this.afterConditionNumberOfEvents = afterConditionNumberOfEvents;
    }

    @Override
    public boolean checkUpdateAfterCondition(EventBean[] newEvents, StatementContext statementContext) {
        return this.isAfterConditionSatisfied || this.checkAfterCondition(newEvents == null ? 0 : newEvents.length, statementContext);
    }

    @Override
    public boolean checkUpdateAfterCondition(Set<MultiKey<EventBean>> newEvents, StatementContext statementContext) {
        return this.isAfterConditionSatisfied || this.checkAfterCondition(newEvents == null ? 0 : newEvents.size(), statementContext);
    }

    @Override
    public boolean checkUpdateAfterCondition(UniformPair<EventBean[]> newOldEvents, StatementContext statementContext) {
        return this.isAfterConditionSatisfied || this.checkAfterCondition(newOldEvents == null ? 0 : (newOldEvents.getFirst() == null ? 0 : newOldEvents.getFirst().length), statementContext);
    }

    @Override
    public void destroy() {
    }

    private boolean checkAfterCondition(int numOutputEvents, StatementContext statementContext) {
        if (this.afterConditionTime != null) {
            long time = statementContext.getTimeProvider().getTime();
            if (time < this.afterConditionTime) {
                return false;
            }
            this.isAfterConditionSatisfied = true;
            return true;
        }
        if (this.afterConditionNumberOfEvents != null) {
            this.afterConditionEventsFound += numOutputEvents;
            if (this.afterConditionEventsFound <= this.afterConditionNumberOfEvents) {
                return false;
            }
            this.isAfterConditionSatisfied = true;
            return true;
        }
        this.isAfterConditionSatisfied = true;
        return true;
    }
}

