/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import java.util.Map;

public class EventBeanManufacturerObjectArray
implements EventBeanManufacturer {
    private final ObjectArrayEventType eventType;
    private final EventAdapterService eventAdapterService;
    private final int[] indexPerWritable;
    private final boolean oneToOne;

    public EventBeanManufacturerObjectArray(ObjectArrayEventType eventType, EventAdapterService eventAdapterService, WriteablePropertyDescriptor[] properties) {
        this.eventAdapterService = eventAdapterService;
        this.eventType = eventType;
        Map<String, Integer> indexes = eventType.getPropertiesIndexes();
        this.indexPerWritable = new int[properties.length];
        boolean oneToOneMapping = true;
        for (int i = 0; i < properties.length; ++i) {
            String propertyName = properties[i].getPropertyName();
            Integer index = indexes.get(propertyName);
            if (index == null) {
                throw new IllegalStateException("Failed to find property '" + propertyName + "' among the array indexes");
            }
            this.indexPerWritable[i] = index;
            if (index == i) continue;
            oneToOneMapping = false;
        }
        this.oneToOne = oneToOneMapping && properties.length == eventType.getPropertyNames().length;
    }

    @Override
    public EventBean make(Object[] properties) {
        Object[] cols = this.makeUnderlying(properties);
        return this.eventAdapterService.adapterForTypedObjectArray(cols, this.eventType);
    }

    public Object[] makeUnderlying(Object[] properties) {
        if (this.oneToOne) {
            return properties;
        }
        Object[] cols = new Object[this.eventType.getPropertyNames().length];
        for (int i = 0; i < properties.length; ++i) {
            int indexToWrite = this.indexPerWritable[i];
            cols[indexToWrite] = properties[i];
        }
        return cols;
    }
}

