/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.EPRuntimeEventSender;
import com.espertech.esper.core.thread.InboundUnitSendWrapped;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.event.EventAdapterService;

public class EventSenderAvro
implements EventSender {
    private final EPRuntimeEventSender runtimeEventSender;
    private final EventAdapterService eventAdapterService;
    private final EventType eventType;
    private final ThreadingService threadingService;

    public EventSenderAvro(EPRuntimeEventSender runtimeEventSender, EventType eventType, EventAdapterService eventAdapterService, ThreadingService threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.eventType = eventType;
        this.threadingService = threadingService;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public void sendEvent(Object theEvent) {
        EventBean eventBean = this.eventAdapterService.adapterForTypedAvro(theEvent, this.eventType);
        if (ThreadingOption.isThreadingEnabled && this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(new InboundUnitSendWrapped(eventBean, this.runtimeEventSender));
        } else {
            this.runtimeEventSender.processWrappedEvent(eventBean);
        }
    }

    @Override
    public void route(Object theEvent) {
        if (!theEvent.getClass().isArray()) {
            throw new EPException("Unexpected event object of type " + theEvent.getClass().getName() + ", expected Object[]");
        }
        EventBean eventBean = this.eventAdapterService.adapterForTypedAvro(theEvent, this.eventType);
        this.runtimeEventSender.routeEventBean(eventBean);
    }
}

