/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.core.service.EPRuntimeEventSender;
import com.espertech.esper.core.thread.InboundUnitSendWrapped;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.event.EventSenderURIDesc;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSenderImpl
implements EventSender {
    private static Logger log = LoggerFactory.getLogger(EventSenderImpl.class);
    private final List<EventSenderURIDesc> handlingFactories;
    private final EPRuntimeEventSender epRuntime;
    private final ThreadingService threadingService;

    public EventSenderImpl(List<EventSenderURIDesc> handlingFactories, EPRuntimeEventSender epRuntime, ThreadingService threadingService) {
        this.handlingFactories = handlingFactories;
        this.epRuntime = epRuntime;
        this.threadingService = threadingService;
    }

    @Override
    public void sendEvent(Object theEvent) throws EPException {
        this.sendIn(theEvent, false);
    }

    @Override
    public void route(Object theEvent) throws EPException {
        this.sendIn(theEvent, true);
    }

    private void sendIn(Object theEvent, boolean isRoute) throws EPException {
        for (EventSenderURIDesc entry : this.handlingFactories) {
            EventBean eventBean = null;
            try {
                eventBean = entry.getBeanFactory().create(theEvent, entry.getResolutionURI());
            }
            catch (RuntimeException ex) {
                log.warn("Unexpected exception thrown by plug-in event bean factory '" + entry.getBeanFactory() + "' processing event " + theEvent, (Throwable)ex);
            }
            if (eventBean == null) continue;
            if (isRoute) {
                this.epRuntime.routeEventBean(eventBean);
            } else if (ThreadingOption.isThreadingEnabled && this.threadingService.isInboundThreading()) {
                this.threadingService.submitInbound(new InboundUnitSendWrapped(eventBean, this.epRuntime));
            } else {
                this.epRuntime.processWrappedEvent(eventBean);
            }
            return;
        }
    }
}

