/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventPropertyGetterIndexed;
import com.espertech.esper.client.EventPropertyGetterMapped;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.DecoratingEventBean;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanWriter;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.WrapperEventBeanCopyMethod;
import com.espertech.esper.event.WrapperEventBeanMapCopyMethod;
import com.espertech.esper.event.WrapperEventBeanMapWriter;
import com.espertech.esper.event.WrapperEventBeanPropertyWriter;
import com.espertech.esper.event.WrapperEventBeanUndCopyMethod;
import com.espertech.esper.event.WrapperEventBeanUndWriter;
import com.espertech.esper.event.map.MapEventType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WrapperEventType
implements EventTypeSPI {
    protected final EventTypeMetadata metadata;
    protected final EventType underlyingEventType;
    protected final MapEventType underlyingMapType;
    private String[] propertyNames;
    private EventPropertyDescriptor[] propertyDesc;
    private Map<String, EventPropertyDescriptor> propertyDescriptorMap;
    private final int eventTypeId;
    private final boolean isNoMapProperties;
    private final Map<String, EventPropertyGetter> propertyGetterCache;
    private final EventAdapterService eventAdapterService;
    private EventPropertyDescriptor[] writableProperties;
    private Map<String, Pair<EventPropertyDescriptor, EventPropertyWriter>> writers;
    private String startTimestampPropertyName;
    private String endTimestampPropertyName;
    private int numPropertiesUnderlyingType;

    public WrapperEventType(EventTypeMetadata metadata, String typeName, int eventTypeId, EventType eventType, Map<String, Object> properties, EventAdapterService eventAdapterService) {
        this.checkForRepeatedPropertyNames(eventType, properties);
        this.metadata = metadata;
        this.underlyingEventType = eventType;
        EventTypeMetadata metadataMapType = EventTypeMetadata.createAnonymous(typeName, EventTypeMetadata.ApplicationType.MAP);
        this.underlyingMapType = new MapEventType(metadataMapType, typeName, 0, eventAdapterService, properties, null, null, null);
        this.isNoMapProperties = properties.isEmpty();
        this.eventAdapterService = eventAdapterService;
        this.eventTypeId = eventTypeId;
        this.propertyGetterCache = new HashMap<String, EventPropertyGetter>();
        this.updatePropertySet();
        if (metadata.getTypeClass() == EventTypeMetadata.TypeClass.NAMED_WINDOW) {
            this.startTimestampPropertyName = eventType.getStartTimestampPropertyName();
            this.endTimestampPropertyName = eventType.getEndTimestampPropertyName();
            EventTypeUtility.validateTimestampProperties(this, this.startTimestampPropertyName, this.endTimestampPropertyName);
        }
    }

    private void checkInitProperties() {
        if (this.numPropertiesUnderlyingType != this.underlyingEventType.getPropertyDescriptors().length) {
            this.updatePropertySet();
        }
    }

    private void updatePropertySet() {
        PropertyDescriptorComposite compositeProperties = WrapperEventType.getCompositeProperties(this.underlyingEventType, this.underlyingMapType);
        this.propertyNames = compositeProperties.getPropertyNames();
        this.propertyDescriptorMap = compositeProperties.getPropertyDescriptorMap();
        this.propertyDesc = compositeProperties.getDescriptors();
        this.numPropertiesUnderlyingType = this.underlyingEventType.getPropertyDescriptors().length;
    }

    private static PropertyDescriptorComposite getCompositeProperties(EventType underlyingEventType, MapEventType underlyingMapType) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.addAll(Arrays.asList(underlyingEventType.getPropertyNames()));
        propertyNames.addAll(Arrays.asList(underlyingMapType.getPropertyNames()));
        String[] propertyNamesArr = propertyNames.toArray(new String[propertyNames.size()]);
        ArrayList<EventPropertyDescriptor> propertyDesc = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, EventPropertyDescriptor> propertyDescriptorMap = new HashMap<String, EventPropertyDescriptor>();
        for (EventPropertyDescriptor eventProperty : underlyingEventType.getPropertyDescriptors()) {
            propertyDesc.add(eventProperty);
            propertyDescriptorMap.put(eventProperty.getPropertyName(), eventProperty);
        }
        for (EventPropertyDescriptor mapProperty : underlyingMapType.getPropertyDescriptors()) {
            propertyDesc.add(mapProperty);
            propertyDescriptorMap.put(mapProperty.getPropertyName(), mapProperty);
        }
        EventPropertyDescriptor[] propertyDescArr = propertyDesc.toArray(new EventPropertyDescriptor[propertyDesc.size()]);
        return new PropertyDescriptorComposite(propertyDescriptorMap, propertyNamesArr, propertyDescArr);
    }

    @Override
    public String getStartTimestampPropertyName() {
        return this.startTimestampPropertyName;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return this.endTimestampPropertyName;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    @Override
    public String getName() {
        return this.metadata.getPublicName();
    }

    @Override
    public int getEventTypeId() {
        return this.eventTypeId;
    }

    @Override
    public EventPropertyGetter getGetter(final String property) {
        EventPropertyGetter cachedGetter = this.propertyGetterCache.get(property);
        if (cachedGetter != null) {
            return cachedGetter;
        }
        if (this.underlyingMapType.isProperty(property) && property.indexOf(63) == -1) {
            final EventPropertyGetter mapGetter = this.underlyingMapType.getGetter(property);
            EventPropertyGetter getter = new EventPropertyGetter(){

                @Override
                public Object get(EventBean theEvent) {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    Map<String, Object> map = wrapperEvent.getDecoratingProperties();
                    return mapGetter.get(WrapperEventType.this.eventAdapterService.adapterForTypedMap(map, WrapperEventType.this.underlyingMapType));
                }

                @Override
                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }

                @Override
                public Object getFragment(EventBean theEvent) {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    Map<String, Object> map = wrapperEvent.getDecoratingProperties();
                    return mapGetter.getFragment(WrapperEventType.this.eventAdapterService.adapterForTypedMap(map, WrapperEventType.this.underlyingMapType));
                }
            };
            this.propertyGetterCache.put(property, getter);
            return getter;
        }
        if (this.underlyingEventType.isProperty(property)) {
            EventPropertyGetter getter = new EventPropertyGetter(){

                @Override
                public Object get(EventBean theEvent) {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    EventBean wrappedEvent = wrapperEvent.getUnderlyingEvent();
                    if (wrappedEvent == null) {
                        return null;
                    }
                    EventPropertyGetter underlyingGetter = WrapperEventType.this.underlyingEventType.getGetter(property);
                    return underlyingGetter.get(wrappedEvent);
                }

                @Override
                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }

                @Override
                public Object getFragment(EventBean theEvent) {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    EventBean wrappedEvent = wrapperEvent.getUnderlyingEvent();
                    if (wrappedEvent == null) {
                        return null;
                    }
                    EventPropertyGetter underlyingGetter = WrapperEventType.this.underlyingEventType.getGetter(property);
                    return underlyingGetter.getFragment(wrappedEvent);
                }
            };
            this.propertyGetterCache.put(property, getter);
            return getter;
        }
        return null;
    }

    @Override
    public EventPropertyGetterMapped getGetterMapped(String mappedProperty) {
        final EventPropertyGetterMapped undMapped = this.underlyingEventType.getGetterMapped(mappedProperty);
        if (undMapped != null) {
            return new EventPropertyGetterMapped(){

                @Override
                public Object get(EventBean theEvent, String mapKey) throws PropertyAccessException {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    EventBean wrappedEvent = wrapperEvent.getUnderlyingEvent();
                    if (wrappedEvent == null) {
                        return null;
                    }
                    return undMapped.get(wrappedEvent, mapKey);
                }
            };
        }
        final EventPropertyGetterMapped decoMapped = this.underlyingMapType.getGetterMapped(mappedProperty);
        if (decoMapped != null) {
            return new EventPropertyGetterMapped(){

                @Override
                public Object get(EventBean theEvent, String mapKey) throws PropertyAccessException {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    Map<String, Object> map = wrapperEvent.getDecoratingProperties();
                    return decoMapped.get(WrapperEventType.this.eventAdapterService.adapterForTypedMap(map, WrapperEventType.this.underlyingMapType), mapKey);
                }
            };
        }
        return null;
    }

    @Override
    public EventPropertyGetterIndexed getGetterIndexed(String indexedProperty) {
        final EventPropertyGetterIndexed undIndexed = this.underlyingEventType.getGetterIndexed(indexedProperty);
        if (undIndexed != null) {
            return new EventPropertyGetterIndexed(){

                @Override
                public Object get(EventBean theEvent, int index) throws PropertyAccessException {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    EventBean wrappedEvent = wrapperEvent.getUnderlyingEvent();
                    if (wrappedEvent == null) {
                        return null;
                    }
                    return undIndexed.get(wrappedEvent, index);
                }
            };
        }
        final EventPropertyGetterIndexed decoIndexed = this.underlyingMapType.getGetterIndexed(indexedProperty);
        if (decoIndexed != null) {
            return new EventPropertyGetterIndexed(){

                @Override
                public Object get(EventBean theEvent, int index) throws PropertyAccessException {
                    if (!(theEvent instanceof DecoratingEventBean)) {
                        throw new PropertyAccessException("Mismatched property getter to EventBean type");
                    }
                    DecoratingEventBean wrapperEvent = (DecoratingEventBean)((Object)theEvent);
                    Map<String, Object> map = wrapperEvent.getDecoratingProperties();
                    return decoIndexed.get(WrapperEventType.this.eventAdapterService.adapterForTypedMap(map, WrapperEventType.this.underlyingMapType), index);
                }
            };
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        this.checkInitProperties();
        return this.propertyNames;
    }

    @Override
    public Class getPropertyType(String property) {
        if (this.underlyingEventType.isProperty(property)) {
            return this.underlyingEventType.getPropertyType(property);
        }
        if (this.underlyingMapType.isProperty(property)) {
            return this.underlyingMapType.getPropertyType(property);
        }
        return null;
    }

    @Override
    public EventBeanReader getReader() {
        return null;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Class getUnderlyingType() {
        if (this.isNoMapProperties) {
            return this.underlyingEventType.getUnderlyingType();
        }
        return Pair.class;
    }

    public EventType getUnderlyingEventType() {
        return this.underlyingEventType;
    }

    public MapEventType getUnderlyingMapType() {
        return this.underlyingMapType;
    }

    @Override
    public boolean isProperty(String property) {
        return this.underlyingEventType.isProperty(property) || this.underlyingMapType.isProperty(property);
    }

    public String toString() {
        return "WrapperEventType underlyingEventType=" + this.underlyingEventType + " underlyingMapType=" + this.underlyingMapType;
    }

    @Override
    public boolean equalsCompareType(EventType otherEventType) {
        if (this == otherEventType) {
            return true;
        }
        if (!(otherEventType instanceof WrapperEventType)) {
            return false;
        }
        WrapperEventType other = (WrapperEventType)otherEventType;
        if (!other.underlyingMapType.equalsCompareType(this.underlyingMapType)) {
            return false;
        }
        if (!(other.underlyingEventType instanceof EventTypeSPI) || !(this.underlyingEventType instanceof EventTypeSPI)) {
            return other.underlyingEventType.equals(this.underlyingEventType);
        }
        EventTypeSPI otherUnderlying = (EventTypeSPI)other.underlyingEventType;
        EventTypeSPI thisUnderlying = (EventTypeSPI)this.underlyingEventType;
        return otherUnderlying.equalsCompareType(thisUnderlying);
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        this.checkInitProperties();
        return this.propertyDesc;
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        this.checkInitProperties();
        return this.propertyDescriptorMap.get(propertyName);
    }

    @Override
    public FragmentEventType getFragmentType(String property) {
        FragmentEventType fragment = this.underlyingEventType.getFragmentType(property);
        if (fragment != null) {
            return fragment;
        }
        return this.underlyingMapType.getFragmentType(property);
    }

    @Override
    public EventPropertyWriter getWriter(String propertyName) {
        Pair<EventPropertyDescriptor, EventPropertyWriter> pair;
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        if ((pair = this.writers.get(propertyName)) == null) {
            return null;
        }
        return pair.getSecond();
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        Pair<EventPropertyDescriptor, EventPropertyWriter> pair;
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        if ((pair = this.writers.get(propertyName)) == null) {
            return null;
        }
        return pair.getFirst();
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        return this.writableProperties;
    }

    private void initializeWriters() {
        ArrayList<EventPropertyDescriptor> writables = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, Pair<EventPropertyDescriptor, EventPropertyWriter>> writerMap = new HashMap<String, Pair<EventPropertyDescriptor, EventPropertyWriter>>();
        writables.addAll(Arrays.asList(this.underlyingMapType.getWriteableProperties()));
        for (EventPropertyDescriptor writableMapProp : this.underlyingMapType.getWriteableProperties()) {
            final String propertyName = writableMapProp.getPropertyName();
            writables.add(writableMapProp);
            EventPropertyWriter writer = new EventPropertyWriter(){

                @Override
                public void write(Object value, EventBean target) {
                    DecoratingEventBean decorated = (DecoratingEventBean)((Object)target);
                    decorated.getDecoratingProperties().put(propertyName, value);
                }
            };
            writerMap.put(propertyName, new Pair<EventPropertyDescriptor, 7>(writableMapProp, writer));
        }
        if (this.underlyingEventType instanceof EventTypeSPI) {
            EventTypeSPI spi = (EventTypeSPI)this.underlyingEventType;
            for (EventPropertyDescriptor writableUndProp : spi.getWriteableProperties()) {
                String propertyName = writableUndProp.getPropertyName();
                final EventPropertyWriter innerWriter = spi.getWriter(propertyName);
                if (innerWriter == null) continue;
                writables.add(writableUndProp);
                EventPropertyWriter writer = new EventPropertyWriter(){

                    @Override
                    public void write(Object value, EventBean target) {
                        DecoratingEventBean decorated = (DecoratingEventBean)((Object)target);
                        innerWriter.write(value, decorated.getUnderlyingEvent());
                    }
                };
                writerMap.put(propertyName, new Pair<EventPropertyDescriptor, 8>(writableUndProp, writer));
            }
        }
        this.writers = writerMap;
        this.writableProperties = writables.toArray(new EventPropertyDescriptor[writables.size()]);
    }

    @Override
    public EventBeanCopyMethod getCopyMethod(String[] properties) {
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        boolean isOnlyMap = true;
        for (int i = 0; i < properties.length; ++i) {
            if (this.underlyingMapType.getWritableProperty(properties[i]) != null) continue;
            isOnlyMap = false;
        }
        boolean isOnlyUnderlying = true;
        if (!isOnlyMap) {
            if (!(this.underlyingEventType instanceof EventTypeSPI)) {
                return null;
            }
            EventTypeSPI spi = (EventTypeSPI)this.underlyingEventType;
            for (int i = 0; i < properties.length; ++i) {
                if (spi.getWritableProperty(properties[i]) != null) continue;
                isOnlyUnderlying = false;
            }
        }
        if (isOnlyMap) {
            return new WrapperEventBeanMapCopyMethod(this, this.eventAdapterService);
        }
        EventBeanCopyMethod undCopyMethod = ((EventTypeSPI)this.underlyingEventType).getCopyMethod(properties);
        if (undCopyMethod == null) {
            return null;
        }
        if (isOnlyUnderlying) {
            return new WrapperEventBeanUndCopyMethod(this, this.eventAdapterService, undCopyMethod);
        }
        return new WrapperEventBeanCopyMethod(this, this.eventAdapterService, undCopyMethod);
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        int i;
        EventTypeSPI spi;
        if (this.writableProperties == null) {
            this.initializeWriters();
        }
        boolean isOnlyMap = true;
        for (int i2 = 0; i2 < properties.length; ++i2) {
            if (!this.writers.containsKey(properties[i2])) {
                return null;
            }
            if (this.underlyingMapType.getWritableProperty(properties[i2]) != null) continue;
            isOnlyMap = false;
        }
        boolean isOnlyUnderlying = true;
        if (!isOnlyMap) {
            spi = (EventTypeSPI)this.underlyingEventType;
            for (i = 0; i < properties.length; ++i) {
                if (spi.getWritableProperty(properties[i]) != null) continue;
                isOnlyUnderlying = false;
            }
        }
        if (isOnlyMap) {
            return new WrapperEventBeanMapWriter(properties);
        }
        if (isOnlyUnderlying) {
            spi = (EventTypeSPI)this.underlyingEventType;
            EventBeanWriter undWriter = spi.getWriter(properties);
            if (undWriter == null) {
                return undWriter;
            }
            return new WrapperEventBeanUndWriter(undWriter);
        }
        EventPropertyWriter[] writerArr = new EventPropertyWriter[properties.length];
        for (i = 0; i < properties.length; ++i) {
            writerArr[i] = this.writers.get(properties[i]).getSecond();
        }
        return new WrapperEventBeanPropertyWriter(writerArr);
    }

    private void checkForRepeatedPropertyNames(EventType eventType, Map<String, Object> properties) {
        for (String property : eventType.getPropertyNames()) {
            if (!properties.keySet().contains(property)) continue;
            throw new EPException("Property " + property + " occurs in both the underlying event and in the additional properties");
        }
    }

    public static class PropertyDescriptorComposite {
        private final HashMap<String, EventPropertyDescriptor> propertyDescriptorMap;
        private final String[] propertyNames;
        private final EventPropertyDescriptor[] descriptors;

        public PropertyDescriptorComposite(HashMap<String, EventPropertyDescriptor> propertyDescriptorMap, String[] propertyNames, EventPropertyDescriptor[] descriptors) {
            this.propertyDescriptorMap = propertyDescriptorMap;
            this.propertyNames = propertyNames;
            this.descriptors = descriptors;
        }

        public HashMap<String, EventPropertyDescriptor> getPropertyDescriptorMap() {
            return this.propertyDescriptorMap;
        }

        public String[] getPropertyNames() {
            return this.propertyNames;
        }

        public EventPropertyDescriptor[] getDescriptors() {
            return this.descriptors;
        }
    }
}

