/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterAndIndexed;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.event.vaevent.PropertyUtility;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ArrayMethodPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndIndexed {
    private final Method method;
    private final int index;

    public ArrayMethodPropertyGetter(Method method, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService, method.getReturnType().getComponentType(), null);
        this.index = index;
        this.method = method;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), index);
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return this.getBeanPropInternal(object, this.index);
    }

    private Object getBeanPropInternal(Object object, int index) throws PropertyAccessException {
        try {
            Object value = this.method.invoke(object, (Object[])null);
            if (Array.getLength(value) <= index) {
                return null;
            }
            return Array.get(value, index);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(this.method, object, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(this.method, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(this.method, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(this.method, e);
        }
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ArrayMethodPropertyGetter  method=" + this.method.toString() + " index=" + this.index;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

