/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.event.map.MapEventType;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapEventBeanCopyMethodWithArrayMap
implements EventBeanCopyMethod {
    private final MapEventType mapEventType;
    private final EventAdapterService eventAdapterService;
    private final Set<String> mapPropertiesToCopy;
    private final Set<String> arrayPropertiesToCopy;

    public MapEventBeanCopyMethodWithArrayMap(MapEventType mapEventType, EventAdapterService eventAdapterService, Set<String> mapPropertiesToCopy, Set<String> arrayPropertiesToCopy) {
        this.mapEventType = mapEventType;
        this.eventAdapterService = eventAdapterService;
        this.mapPropertiesToCopy = mapPropertiesToCopy;
        this.arrayPropertiesToCopy = arrayPropertiesToCopy;
    }

    @Override
    public EventBean copy(EventBean theEvent) {
        MappedEventBean mapped = (MappedEventBean)theEvent;
        Map<String, Object> props = mapped.getProperties();
        HashMap<String, Object> shallowCopy = new HashMap<String, Object>(props);
        for (String name : this.mapPropertiesToCopy) {
            Map innerMap = (Map)props.get(name);
            if (innerMap == null) continue;
            HashMap copy = new HashMap(innerMap);
            shallowCopy.put(name, copy);
        }
        for (String name : this.arrayPropertiesToCopy) {
            Object array = props.get(name);
            if (array == null || !array.getClass().isArray() || Array.getLength(array) == 0) continue;
            Object copied = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array));
            System.arraycopy(array, 0, copied, 0, Array.getLength(array));
            shallowCopy.put(name, copied);
        }
        return this.eventAdapterService.adapterForTypedMap(shallowCopy, this.mapEventType);
    }
}

