/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.property;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterAndIndexed;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.arr.ObjectArrayArrayPOJOEntryIndexedPropertyGetter;
import com.espertech.esper.event.arr.ObjectArrayArrayPropertyGetter;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetterAndIndexed;
import com.espertech.esper.event.bean.ArrayFastPropertyGetter;
import com.espertech.esper.event.bean.ArrayFieldPropertyGetter;
import com.espertech.esper.event.bean.ArrayMethodPropertyGetter;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.InternalEventPropDescriptor;
import com.espertech.esper.event.bean.IterableFastPropertyGetter;
import com.espertech.esper.event.bean.IterableFieldPropertyGetter;
import com.espertech.esper.event.bean.IterableMethodPropertyGetter;
import com.espertech.esper.event.bean.KeyedFastPropertyGetter;
import com.espertech.esper.event.bean.KeyedMethodPropertyGetter;
import com.espertech.esper.event.bean.ListFastPropertyGetter;
import com.espertech.esper.event.bean.ListFieldPropertyGetter;
import com.espertech.esper.event.bean.ListMethodPropertyGetter;
import com.espertech.esper.event.map.MapArrayPOJOEntryIndexedPropertyGetter;
import com.espertech.esper.event.map.MapArrayPropertyGetter;
import com.espertech.esper.event.map.MapEventPropertyGetterAndIndexed;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.property.GenericPropertyDesc;
import com.espertech.esper.event.property.PropertyBase;
import com.espertech.esper.event.property.PropertyWithIndex;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.DOMIndexedGetter;
import com.espertech.esper.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaElementSimple;
import com.espertech.esper.event.xml.SchemaItem;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class IndexedProperty
extends PropertyBase
implements PropertyWithIndex {
    private int index;

    public IndexedProperty(String propertyName) {
        super(propertyName);
    }

    public IndexedProperty(String propertyName, int index) {
        super(propertyName);
        this.index = index;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String[] toPropertyArray() {
        return new String[]{this.getPropertyNameAtomic()};
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public EventPropertyGetterAndIndexed getGetter(BeanEventType eventType, EventAdapterService eventAdapterService) {
        FastClass fastClass = eventType.getFastClass();
        InternalEventPropDescriptor propertyDesc = eventType.getIndexedProperty(this.propertyNameAtomic);
        if (propertyDesc != null) {
            if (fastClass != null) {
                Method method = propertyDesc.getReadMethod();
                FastMethod fastMethod = fastClass.getMethod(method);
                return new KeyedFastPropertyGetter(fastMethod, this.index, eventAdapterService);
            }
            return new KeyedMethodPropertyGetter(propertyDesc.getReadMethod(), this.index, eventAdapterService);
        }
        propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        Class returnType = propertyDesc.getReturnType();
        if (returnType.isArray()) {
            if (propertyDesc.getReadMethod() != null) {
                Method method = propertyDesc.getReadMethod();
                if (fastClass != null) {
                    FastMethod fastMethod = fastClass.getMethod(method);
                    return new ArrayFastPropertyGetter(fastMethod, this.index, eventAdapterService);
                }
                return new ArrayMethodPropertyGetter(method, this.index, eventAdapterService);
            }
            Field field = propertyDesc.getAccessorField();
            return new ArrayFieldPropertyGetter(field, this.index, eventAdapterService);
        }
        if (JavaClassHelper.isImplementsInterface(returnType, List.class)) {
            if (propertyDesc.getReadMethod() != null) {
                Method method = propertyDesc.getReadMethod();
                if (fastClass != null) {
                    FastMethod fastMethod = fastClass.getMethod(method);
                    return new ListFastPropertyGetter(method, fastMethod, this.index, eventAdapterService);
                }
                return new ListMethodPropertyGetter(method, this.index, eventAdapterService);
            }
            Field field = propertyDesc.getAccessorField();
            return new ListFieldPropertyGetter(field, this.index, eventAdapterService);
        }
        if (JavaClassHelper.isImplementsInterface(returnType, Iterable.class)) {
            if (propertyDesc.getReadMethod() != null) {
                Method method = propertyDesc.getReadMethod();
                if (fastClass != null) {
                    FastMethod fastMethod = fastClass.getMethod(method);
                    return new IterableFastPropertyGetter(method, fastMethod, this.index, eventAdapterService);
                }
                return new IterableMethodPropertyGetter(method, this.index, eventAdapterService);
            }
            Field field = propertyDesc.getAccessorField();
            return new IterableFieldPropertyGetter(field, this.index, eventAdapterService);
        }
        return null;
    }

    @Override
    public GenericPropertyDesc getPropertyTypeGeneric(BeanEventType eventType, EventAdapterService eventAdapterService) {
        InternalEventPropDescriptor descriptor = eventType.getIndexedProperty(this.propertyNameAtomic);
        if (descriptor != null) {
            return new GenericPropertyDesc(descriptor.getReturnType());
        }
        descriptor = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (descriptor == null) {
            return null;
        }
        Class returnType = descriptor.getReturnType();
        if (returnType.isArray()) {
            return new GenericPropertyDesc(returnType.getComponentType());
        }
        if (JavaClassHelper.isImplementsInterface(returnType, Iterable.class)) {
            if (descriptor.getReadMethod() != null) {
                Class genericType = JavaClassHelper.getGenericReturnType(descriptor.getReadMethod(), false);
                return new GenericPropertyDesc(genericType);
            }
            if (descriptor.getAccessorField() != null) {
                Class genericType = JavaClassHelper.getGenericFieldType(descriptor.getAccessorField(), false);
                return new GenericPropertyDesc(genericType);
            }
            return null;
        }
        return null;
    }

    @Override
    public Class getPropertyType(BeanEventType eventType, EventAdapterService eventAdapterService) {
        InternalEventPropDescriptor descriptor = eventType.getIndexedProperty(this.propertyNameAtomic);
        if (descriptor != null) {
            return descriptor.getReturnType();
        }
        descriptor = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (descriptor == null) {
            return null;
        }
        Class returnType = descriptor.getReturnType();
        if (returnType.isArray()) {
            return returnType.getComponentType();
        }
        if (JavaClassHelper.isImplementsInterface(returnType, Iterable.class)) {
            if (descriptor.getReadMethod() != null) {
                return JavaClassHelper.getGenericReturnType(descriptor.getReadMethod(), false);
            }
            if (descriptor.getAccessorField() != null) {
                return JavaClassHelper.getGenericFieldType(descriptor.getAccessorField(), false);
            }
            return null;
        }
        return null;
    }

    @Override
    public Class getPropertyTypeMap(Map optionalMapPropTypes, EventAdapterService eventAdapterService) {
        Object type = optionalMapPropTypes.get(this.propertyNameAtomic);
        if (type == null) {
            return null;
        }
        if (type instanceof String) {
            EventType innerType;
            String nestedName = type.toString();
            boolean isArray = EventTypeUtility.isPropertyArray(nestedName);
            if (isArray) {
                nestedName = EventTypeUtility.getPropertyRemoveArray(nestedName);
            }
            if (!((innerType = eventAdapterService.getExistsTypeByName(nestedName)) instanceof MapEventType)) {
                return null;
            }
            if (!isArray) {
                return null;
            }
            return Map[].class;
        }
        if (!(type instanceof Class)) {
            return null;
        }
        if (!((Class)type).isArray()) {
            return null;
        }
        return ((Class)type).getComponentType();
    }

    @Override
    public MapEventPropertyGetterAndIndexed getGetterMap(Map optionalMapPropTypes, EventAdapterService eventAdapterService) {
        Object type = optionalMapPropTypes.get(this.propertyNameAtomic);
        if (type == null) {
            return null;
        }
        if (type instanceof String) {
            EventType innerType;
            String nestedName = type.toString();
            boolean isArray = EventTypeUtility.isPropertyArray(nestedName);
            if (isArray) {
                nestedName = EventTypeUtility.getPropertyRemoveArray(nestedName);
            }
            if (!((innerType = eventAdapterService.getExistsTypeByName(nestedName)) instanceof MapEventType)) {
                return null;
            }
            if (!isArray) {
                return null;
            }
            return new MapArrayPropertyGetter(this.propertyNameAtomic, this.index, eventAdapterService, innerType);
        }
        if (!(type instanceof Class)) {
            return null;
        }
        if (!((Class)type).isArray()) {
            return null;
        }
        Class<?> componentType = ((Class)type).getComponentType();
        return new MapArrayPOJOEntryIndexedPropertyGetter(this.propertyNameAtomic, this.index, eventAdapterService, componentType);
    }

    @Override
    public void toPropertyEPL(StringWriter writer) {
        writer.append(this.propertyNameAtomic);
        writer.append("[");
        writer.append(Integer.toString(this.index));
        writer.append("]");
    }

    @Override
    public EventPropertyGetter getGetterDOM() {
        return new DOMIndexedGetter(this.propertyNameAtomic, this.index, null);
    }

    @Override
    public EventPropertyGetter getGetterDOM(SchemaElementComplex complexProperty, EventAdapterService eventAdapterService, BaseXMLEventType eventType, String propertyExpression) {
        for (SchemaElementSimple simple : complexProperty.getSimpleElements()) {
            if (!simple.isArray() || !simple.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMIndexedGetter(this.propertyNameAtomic, this.index, null);
        }
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            if (!complex.isArray() || !complex.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMIndexedGetter(this.propertyNameAtomic, this.index, new FragmentFactoryDOMGetter(eventAdapterService, eventType, propertyExpression));
        }
        return null;
    }

    @Override
    public SchemaItem getPropertyTypeSchema(SchemaElementComplex complexProperty, EventAdapterService eventAdapterService) {
        for (SchemaElementSimple simple : complexProperty.getSimpleElements()) {
            if (!simple.isArray() || !simple.getName().equals(this.propertyNameAtomic)) continue;
            return new SchemaElementSimple(simple.getName(), simple.getNamespace(), simple.getXsSimpleType(), simple.getTypeName(), false, simple.getFractionDigits());
        }
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            if (!complex.isArray() || !complex.getName().equals(this.propertyNameAtomic)) continue;
            return new SchemaElementComplex(complex.getName(), complex.getNamespace(), complex.getAttributes(), complex.getChildren(), complex.getSimpleElements(), false, complex.getOptionalSimpleType(), complex.getOptionalSimpleTypeName());
        }
        return null;
    }

    public static Integer getIndex(String propertyName) {
        int start = propertyName.indexOf(91);
        int end = propertyName.indexOf(93);
        String indexStr = propertyName.substring(start, end);
        return Integer.parseInt(indexStr);
    }

    @Override
    public ObjectArrayEventPropertyGetterAndIndexed getGetterObjectArray(Map<String, Integer> indexPerProperty, Map<String, Object> nestableTypes, EventAdapterService eventAdapterService) {
        Integer propertyIndex = indexPerProperty.get(this.propertyNameAtomic);
        if (propertyIndex == null) {
            return null;
        }
        Object type = nestableTypes.get(this.getPropertyNameAtomic());
        if (type == null) {
            return null;
        }
        if (type instanceof String) {
            EventType innerType;
            String nestedName = type.toString();
            boolean isArray = EventTypeUtility.isPropertyArray(nestedName);
            if (isArray) {
                nestedName = EventTypeUtility.getPropertyRemoveArray(nestedName);
            }
            if (!((innerType = eventAdapterService.getExistsTypeByName(nestedName)) instanceof MapEventType)) {
                return null;
            }
            if (!isArray) {
                return null;
            }
            return new ObjectArrayArrayPropertyGetter(propertyIndex, this.index, eventAdapterService, innerType);
        }
        if (!(type instanceof Class)) {
            return null;
        }
        if (!((Class)type).isArray()) {
            return null;
        }
        Class<?> componentType = ((Class)type).getComponentType();
        return new ObjectArrayArrayPOJOEntryIndexedPropertyGetter(propertyIndex, this.index, eventAdapterService, componentType);
    }
}

