/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.util;

import com.espertech.esper.event.util.OutputValueRenderer;

public class OutputValueRendererJSONString
implements OutputValueRenderer {
    @Override
    public void render(Object object, StringBuilder buf) {
        if (object == null) {
            buf.append("null");
            return;
        }
        OutputValueRendererJSONString.enquote(object.toString(), buf);
    }

    public static void enquote(String s, StringBuilder sb) {
        if (s == null || s.length() == 0) {
            sb.append("\"\"");
            return;
        }
        int len = s.length();
        sb.append('\"');
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c < ' ') {
                String t = "000" + Integer.toHexString(c);
                sb.append("\\u");
                sb.append(t.substring(t.length() - 4));
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
    }
}

