/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

public enum FilterOperator {
    EQUAL("="),
    NOT_EQUAL("!="),
    IS("is"),
    IS_NOT("is not"),
    LESS("<"),
    LESS_OR_EQUAL("<="),
    GREATER_OR_EQUAL(">="),
    GREATER(">"),
    RANGE_OPEN("(,)"),
    RANGE_CLOSED("[,]"),
    RANGE_HALF_OPEN("[,)"),
    RANGE_HALF_CLOSED("(,]"),
    NOT_RANGE_OPEN("-(,)"),
    NOT_RANGE_CLOSED("-[,]"),
    NOT_RANGE_HALF_OPEN("-[,)"),
    NOT_RANGE_HALF_CLOSED("-(,]"),
    IN_LIST_OF_VALUES("in"),
    NOT_IN_LIST_OF_VALUES("!in"),
    BOOLEAN_EXPRESSION("boolean_expr");

    private String textualOp;

    private FilterOperator(String textualOp) {
        this.textualOp = textualOp;
    }

    public boolean isRangeOperator() {
        return this == RANGE_CLOSED || this == RANGE_OPEN || this == RANGE_HALF_OPEN || this == RANGE_HALF_CLOSED;
    }

    public boolean isInvertedRangeOperator() {
        return this == NOT_RANGE_CLOSED || this == NOT_RANGE_OPEN || this == NOT_RANGE_HALF_OPEN || this == NOT_RANGE_HALF_CLOSED;
    }

    public boolean isComparisonOperator() {
        return this == LESS || this == LESS_OR_EQUAL || this == GREATER || this == GREATER_OR_EQUAL;
    }

    public static FilterOperator parseRangeOperator(boolean isInclusiveFirst, boolean isInclusiveLast, boolean isNot) {
        if (isInclusiveFirst && isInclusiveLast) {
            if (isNot) {
                return NOT_RANGE_CLOSED;
            }
            return RANGE_CLOSED;
        }
        if (isInclusiveFirst && !isInclusiveLast) {
            if (isNot) {
                return NOT_RANGE_HALF_OPEN;
            }
            return RANGE_HALF_OPEN;
        }
        if (isInclusiveLast) {
            if (isNot) {
                return NOT_RANGE_HALF_CLOSED;
            }
            return RANGE_HALF_CLOSED;
        }
        if (isNot) {
            return NOT_RANGE_OPEN;
        }
        return RANGE_OPEN;
    }

    public String getTextualOp() {
        return this.textualOp;
    }

    public FilterOperator reversedRelationalOp() {
        if (this == LESS) {
            return GREATER;
        }
        if (this == LESS_OR_EQUAL) {
            return GREATER_OR_EQUAL;
        }
        if (this == GREATER) {
            return LESS;
        }
        if (this == GREATER_OR_EQUAL) {
            return LESS_OR_EQUAL;
        }
        throw new IllegalArgumentException("Not a relational operator: " + (Object)((Object)this));
    }
}

