/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexLookupableBase;
import com.espertech.esper.filter.FilterSpecLookupable;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterParamIndexCompareString
extends FilterParamIndexLookupableBase {
    private final TreeMap<Object, EventEvaluator> constantsMap = new TreeMap();
    private final ReadWriteLock constantsMapRWLock;
    private static final Logger log = LoggerFactory.getLogger(FilterParamIndexCompareString.class);

    public FilterParamIndexCompareString(FilterSpecLookupable lookupable, ReadWriteLock readWriteLock, FilterOperator filterOperator) {
        super(filterOperator, lookupable);
        this.constantsMapRWLock = readWriteLock;
        if (filterOperator != FilterOperator.GREATER && filterOperator != FilterOperator.GREATER_OR_EQUAL && filterOperator != FilterOperator.LESS && filterOperator != FilterOperator.LESS_OR_EQUAL) {
            throw new IllegalArgumentException("Invalid filter operator for index of " + (Object)((Object)filterOperator));
        }
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        return this.constantsMap.get(filterConstant);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator matcher) {
        this.constantsMap.put(filterConstant, matcher);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        return this.constantsMap.remove(filterConstant) != null;
    }

    @Override
    public final int size() {
        return this.constantsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        Object propertyValue = this.lookupable.getGetter().get(theEvent);
        if (propertyValue == null) {
            return;
        }
        FilterOperator filterOperator = this.getFilterOperator();
        this.constantsMapRWLock.readLock().lock();
        try {
            EventEvaluator matcher;
            SortedMap<Object, EventEvaluator> subMap = filterOperator == FilterOperator.GREATER || filterOperator == FilterOperator.GREATER_OR_EQUAL ? this.constantsMap.headMap(propertyValue) : this.constantsMap.tailMap(propertyValue);
            EventEvaluator exactEquals = null;
            if (filterOperator == FilterOperator.LESS) {
                exactEquals = this.constantsMap.get(propertyValue);
            }
            for (EventEvaluator matcher2 : subMap.values()) {
                if (exactEquals != null) {
                    exactEquals = null;
                    continue;
                }
                matcher2.matchEvent(theEvent, matches);
            }
            if (filterOperator == FilterOperator.GREATER_OR_EQUAL && (matcher = this.constantsMap.get(propertyValue)) != null) {
                matcher.matchEvent(theEvent, matches);
            }
        }
        finally {
            this.constantsMapRWLock.readLock().unlock();
        }
    }
}

