/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamExprMap;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamConstant;
import com.espertech.esper.filter.FilterSpecParamEventProp;
import com.espertech.esper.filter.FilterSpecParamEventPropIndexed;
import com.espertech.esper.filter.FilterSpecParamIn;
import com.espertech.esper.filter.FilterSpecParamInValue;
import com.espertech.esper.filter.InSetOfValuesConstant;
import com.espertech.esper.filter.InSetOfValuesEventProp;
import com.espertech.esper.filter.InSetOfValuesEventPropIndexed;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FilterSpecCompilerConsolidateUtil {
    protected static void consolidate(FilterParamExprMap filterParamExprMap, String statementName) {
        boolean haveConsolidated;
        HashMap<Pair<FilterSpecLookupable, FilterOperator>, ArrayList<FilterSpecParam>> mapOfParams = new HashMap<Pair<FilterSpecLookupable, FilterOperator>, ArrayList<FilterSpecParam>>();
        do {
            haveConsolidated = false;
            mapOfParams.clear();
            for (FilterSpecParam currentParam : filterParamExprMap.getFilterParams()) {
                FilterOperator op;
                FilterSpecLookupable lookupable = currentParam.getLookupable();
                Pair<FilterSpecLookupable, FilterOperator> key = new Pair<FilterSpecLookupable, FilterOperator>(lookupable, op = currentParam.getFilterOperator());
                ArrayList<FilterSpecParam> existingParam = (ArrayList<FilterSpecParam>)mapOfParams.get(key);
                if (existingParam == null) {
                    existingParam = new ArrayList<FilterSpecParam>();
                    mapOfParams.put(key, existingParam);
                }
                existingParam.add(currentParam);
            }
            for (List entry : mapOfParams.values()) {
                if (entry.size() <= 1) continue;
                haveConsolidated = true;
                FilterSpecCompilerConsolidateUtil.consolidate(entry, filterParamExprMap, statementName);
            }
        } while (haveConsolidated);
    }

    private static void consolidate(List<FilterSpecParam> items, FilterParamExprMap filterParamExprMap, String statementName) {
        FilterOperator op = items.get(0).getFilterOperator();
        if (op == FilterOperator.NOT_EQUAL) {
            FilterSpecCompilerConsolidateUtil.handleConsolidateNotEqual(items, filterParamExprMap, statementName);
        } else {
            for (int i = 1; i < items.size(); ++i) {
                filterParamExprMap.removeValue(items.get(i));
            }
        }
    }

    private static void handleConsolidateNotEqual(List<FilterSpecParam> parameters, FilterParamExprMap filterParamExprMap, String statementName) {
        ArrayList<FilterSpecParamInValue> values = new ArrayList<FilterSpecParamInValue>();
        ExprNode lastNotEqualsExprNode = null;
        for (FilterSpecParam param : parameters) {
            FilterSpecParam eventProp;
            if (param instanceof FilterSpecParamConstant) {
                FilterSpecParamConstant constantParam = (FilterSpecParamConstant)param;
                Object constant = constantParam.getFilterConstant();
                values.add(new InSetOfValuesConstant(constant));
            } else if (param instanceof FilterSpecParamEventProp) {
                eventProp = (FilterSpecParamEventProp)param;
                values.add(new InSetOfValuesEventProp(((FilterSpecParamEventProp)eventProp).getResultEventAsName(), ((FilterSpecParamEventProp)eventProp).getResultEventProperty(), ((FilterSpecParamEventProp)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventProp)eventProp).getCoercionType())));
            } else if (param instanceof FilterSpecParamEventPropIndexed) {
                eventProp = (FilterSpecParamEventPropIndexed)param;
                values.add(new InSetOfValuesEventPropIndexed(((FilterSpecParamEventPropIndexed)eventProp).getResultEventAsName(), ((FilterSpecParamEventPropIndexed)eventProp).getResultEventIndex(), ((FilterSpecParamEventPropIndexed)eventProp).getResultEventProperty(), ((FilterSpecParamEventPropIndexed)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventPropIndexed)eventProp).getCoercionType()), statementName));
            } else {
                throw new IllegalArgumentException("Unknown filter parameter:" + param.toString());
            }
            lastNotEqualsExprNode = filterParamExprMap.removeEntry(param);
        }
        FilterSpecParamIn param = new FilterSpecParamIn(parameters.get(0).getLookupable(), FilterOperator.NOT_IN_LIST_OF_VALUES, values);
        filterParamExprMap.put(lastNotEqualsExprNode, param);
    }
}

