/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprConstantNode;
import com.espertech.esper.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.funcs.ExprPlugInSingleRowNode;
import com.espertech.esper.epl.expression.ops.ExprBetweenNode;
import com.espertech.esper.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.epl.expression.ops.ExprInNode;
import com.espertech.esper.epl.expression.ops.ExprInNodeImpl;
import com.espertech.esper.epl.expression.ops.ExprOrNode;
import com.espertech.esper.epl.expression.ops.ExprRelationalOpNode;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.NestedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamConstant;
import com.espertech.esper.filter.FilterSpecParamContextProp;
import com.espertech.esper.filter.FilterSpecParamEventProp;
import com.espertech.esper.filter.FilterSpecParamEventPropIndexed;
import com.espertech.esper.filter.FilterSpecParamIn;
import com.espertech.esper.filter.FilterSpecParamInValue;
import com.espertech.esper.filter.FilterSpecParamRange;
import com.espertech.esper.filter.FilterSpecParamRangeValue;
import com.espertech.esper.filter.InSetOfValuesConstant;
import com.espertech.esper.filter.InSetOfValuesContextProp;
import com.espertech.esper.filter.InSetOfValuesEventProp;
import com.espertech.esper.filter.InSetOfValuesEventPropIndexed;
import com.espertech.esper.filter.RangeValueContextProp;
import com.espertech.esper.filter.RangeValueDouble;
import com.espertech.esper.filter.RangeValueEventProp;
import com.espertech.esper.filter.RangeValueEventPropIndexed;
import com.espertech.esper.filter.RangeValueString;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FilterSpecCompilerMakeParamUtil {
    protected static FilterSpecParam makeFilterParam(ExprNode constituent, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) throws ExprValidationException {
        FilterSpecParam param;
        if ((constituent instanceof ExprEqualsNode || constituent instanceof ExprRelationalOpNode) && (param = FilterSpecCompilerMakeParamUtil.handleEqualsAndRelOp(constituent, arrayEventTypes, exprEvaluatorContext, statementName)) != null) {
            return param;
        }
        if ((constituent = FilterSpecCompilerMakeParamUtil.rewriteOrToInIfApplicable(constituent)) instanceof ExprInNode && (param = FilterSpecCompilerMakeParamUtil.handleInSetNode((ExprInNode)constituent, arrayEventTypes, exprEvaluatorContext, statementName)) != null) {
            return param;
        }
        if (constituent instanceof ExprBetweenNode && (param = FilterSpecCompilerMakeParamUtil.handleRangeNode((ExprBetweenNode)constituent, arrayEventTypes, exprEvaluatorContext, statementName)) != null) {
            return param;
        }
        if (constituent instanceof ExprPlugInSingleRowNode && (param = FilterSpecCompilerMakeParamUtil.handlePlugInSingleRow((ExprPlugInSingleRowNode)constituent)) != null) {
            return param;
        }
        return null;
    }

    public static ExprNode rewriteOrToInIfApplicable(ExprNode constituent) {
        ExprNode commonExpressionNode;
        ExprNode rhs;
        ExprNode[] childNodes;
        if (!(constituent instanceof ExprOrNode) || constituent.getChildNodes().length < 2) {
            return constituent;
        }
        for (ExprNode child : childNodes = constituent.getChildNodes()) {
            if (!(child instanceof ExprEqualsNode)) {
                return constituent;
            }
            ExprEqualsNode equalsNode = (ExprEqualsNode)child;
            if (!equalsNode.isIs() && !equalsNode.isNotEquals()) continue;
            return constituent;
        }
        ExprNode lhs = childNodes[0].getChildNodes()[0];
        if (ExprNodeUtility.deepEquals(lhs, rhs = childNodes[0].getChildNodes()[1])) {
            return constituent;
        }
        if (FilterSpecCompilerMakeParamUtil.isExprExistsInAllEqualsChildNodes(childNodes, lhs)) {
            commonExpressionNode = lhs;
        } else if (FilterSpecCompilerMakeParamUtil.isExprExistsInAllEqualsChildNodes(childNodes, rhs)) {
            commonExpressionNode = rhs;
        } else {
            return constituent;
        }
        ExprInNodeImpl in = new ExprInNodeImpl(false);
        in.addChildNode(commonExpressionNode);
        for (int i = 0; i < constituent.getChildNodes().length; ++i) {
            ExprNode child = constituent.getChildNodes()[i];
            int nodeindex = ExprNodeUtility.deepEquals(commonExpressionNode, childNodes[i].getChildNodes()[0]) ? 1 : 0;
            in.addChildNode(child.getChildNodes()[nodeindex]);
        }
        try {
            in.validateWithoutContext();
        }
        catch (ExprValidationException ex) {
            return constituent;
        }
        return in;
    }

    private static FilterSpecParam handlePlugInSingleRow(ExprPlugInSingleRowNode constituent) {
        if (JavaClassHelper.getBoxedType(constituent.getExprEvaluator().getType()) != Boolean.class) {
            return null;
        }
        if (!constituent.getFilterLookupEligible()) {
            return null;
        }
        FilterSpecLookupable lookupable = constituent.getFilterLookupable();
        return new FilterSpecParamConstant(lookupable, FilterOperator.EQUAL, true);
    }

    private static FilterSpecParam handleRangeNode(ExprBetweenNode betweenNode, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) {
        ExprNode left = betweenNode.getChildNodes()[0];
        if (left instanceof ExprFilterOptimizableNode) {
            ExprFilterOptimizableNode filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
            FilterSpecLookupable lookupable = filterOptimizableNode.getFilterLookupable();
            FilterOperator op = FilterOperator.parseRangeOperator(betweenNode.isLowEndpointIncluded(), betweenNode.isHighEndpointIncluded(), betweenNode.isNotBetween());
            FilterSpecParamRangeValue low = FilterSpecCompilerMakeParamUtil.handleRangeNodeEndpoint(betweenNode.getChildNodes()[1], arrayEventTypes, exprEvaluatorContext, statementName);
            FilterSpecParamRangeValue high = FilterSpecCompilerMakeParamUtil.handleRangeNodeEndpoint(betweenNode.getChildNodes()[2], arrayEventTypes, exprEvaluatorContext, statementName);
            if (low != null && high != null) {
                return new FilterSpecParamRange(lookupable, op, low, high);
            }
        }
        return null;
    }

    private static FilterSpecParamRangeValue handleRangeNodeEndpoint(ExprNode endpoint, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) {
        if (ExprNodeUtility.isConstantValueExpr(endpoint)) {
            ExprConstantNode node = (ExprConstantNode)endpoint;
            Object value = node.getConstantValue(exprEvaluatorContext);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return new RangeValueString((String)value);
            }
            return new RangeValueDouble(((Number)value).doubleValue());
        }
        if (endpoint instanceof ExprContextPropertyNode) {
            ExprContextPropertyNode node = (ExprContextPropertyNode)endpoint;
            return new RangeValueContextProp(node.getGetter());
        }
        if (endpoint instanceof ExprIdentNode) {
            ExprIdentNode identNodeInner = (ExprIdentNode)endpoint;
            if (identNodeInner.getStreamId() == 0) {
                return null;
            }
            if (arrayEventTypes != null && !arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(identNodeInner.getResolvedStreamName())) {
                Pair<Integer, String> indexAndProp = FilterSpecCompilerMakeParamUtil.getStreamIndex(identNodeInner.getResolvedPropertyName());
                return new RangeValueEventPropIndexed(identNodeInner.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), statementName);
            }
            return new RangeValueEventProp(identNodeInner.getResolvedStreamName(), identNodeInner.getResolvedPropertyName());
        }
        return null;
    }

    private static FilterSpecParam handleInSetNode(ExprInNode constituent, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) throws ExprValidationException {
        ExprNode left = constituent.getChildNodes()[0];
        if (!(left instanceof ExprFilterOptimizableNode)) {
            return null;
        }
        ExprFilterOptimizableNode filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
        FilterSpecLookupable lookupable = filterOptimizableNode.getFilterLookupable();
        FilterOperator op = FilterOperator.IN_LIST_OF_VALUES;
        if (constituent.isNotIn()) {
            op = FilterOperator.NOT_IN_LIST_OF_VALUES;
        }
        int expectedNumberOfConstants = constituent.getChildNodes().length - 1;
        ArrayList<FilterSpecParamInValue> listofValues = new ArrayList<FilterSpecParamInValue>();
        Iterator<ExprNode> it = Arrays.asList(constituent.getChildNodes()).iterator();
        it.next();
        while (it.hasNext()) {
            FilterSpecParamInValue inValue;
            ExprNode subNode = it.next();
            if (ExprNodeUtility.isConstantValueExpr(subNode)) {
                ExprConstantNode constantNode = (ExprConstantNode)subNode;
                Object constant = constantNode.getConstantValue(exprEvaluatorContext);
                if (constant instanceof Collection) {
                    return null;
                }
                if (constant instanceof Map) {
                    return null;
                }
                if (constant != null && constant.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(constant); ++i) {
                        Object arrayElement = Array.get(constant, i);
                        Object arrayElementCoerced = FilterSpecCompilerMakeParamUtil.handleConstantsCoercion(lookupable, arrayElement);
                        listofValues.add(new InSetOfValuesConstant(arrayElementCoerced));
                        if (i <= 0) continue;
                        ++expectedNumberOfConstants;
                    }
                } else {
                    constant = FilterSpecCompilerMakeParamUtil.handleConstantsCoercion(lookupable, constant);
                    listofValues.add(new InSetOfValuesConstant(constant));
                }
            }
            if (subNode instanceof ExprContextPropertyNode) {
                SimpleNumberCoercer coercer;
                ExprContextPropertyNode contextPropertyNode = (ExprContextPropertyNode)subNode;
                Class returnType = contextPropertyNode.getType();
                if (JavaClassHelper.isCollectionMapOrArray(returnType)) {
                    FilterSpecCompilerMakeParamUtil.checkArrayCoercion(returnType, lookupable.getReturnType(), lookupable.getExpression());
                    coercer = null;
                } else {
                    coercer = FilterSpecCompilerMakeParamUtil.getNumberCoercer(left.getExprEvaluator().getType(), contextPropertyNode.getType(), lookupable.getExpression());
                }
                Class finalReturnType = coercer != null ? coercer.getReturnType() : returnType;
                listofValues.add(new InSetOfValuesContextProp(contextPropertyNode.getPropertyName(), contextPropertyNode.getGetter(), coercer, finalReturnType));
            }
            if (!(subNode instanceof ExprIdentNode)) continue;
            ExprIdentNode identNodeInner = (ExprIdentNode)subNode;
            if (identNodeInner.getStreamId() == 0) break;
            boolean isMustCoerce = false;
            Class coerceToType = JavaClassHelper.getBoxedType(lookupable.getReturnType());
            Class identReturnType = identNodeInner.getExprEvaluator().getType();
            if (JavaClassHelper.isCollectionMapOrArray(identReturnType)) {
                FilterSpecCompilerMakeParamUtil.checkArrayCoercion(identReturnType, lookupable.getReturnType(), lookupable.getExpression());
                coerceToType = identReturnType;
            } else if (identReturnType != lookupable.getReturnType()) {
                if (!JavaClassHelper.isNumeric(lookupable.getReturnType())) break;
                if (!JavaClassHelper.canCoerce(identReturnType, lookupable.getReturnType())) {
                    FilterSpecCompilerMakeParamUtil.throwConversionError(identReturnType, lookupable.getReturnType(), lookupable.getExpression());
                }
                isMustCoerce = true;
            }
            String streamName = identNodeInner.getResolvedStreamName();
            if (arrayEventTypes != null && !arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(streamName)) {
                Pair<Integer, String> indexAndProp = FilterSpecCompilerMakeParamUtil.getStreamIndex(identNodeInner.getResolvedPropertyName());
                inValue = new InSetOfValuesEventPropIndexed(identNodeInner.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), isMustCoerce, coerceToType, statementName);
            } else {
                inValue = new InSetOfValuesEventProp(identNodeInner.getResolvedStreamName(), identNodeInner.getResolvedPropertyName(), isMustCoerce, coerceToType);
            }
            listofValues.add(inValue);
        }
        if (listofValues.size() == expectedNumberOfConstants) {
            return new FilterSpecParamIn(lookupable, op, listofValues);
        }
        return null;
    }

    private static void checkArrayCoercion(Class returnTypeValue, Class returnTypeLookupable, String propertyName) throws ExprValidationException {
        if (returnTypeValue == null || !returnTypeValue.isArray()) {
            return;
        }
        if (!JavaClassHelper.isArrayTypeCompatible(returnTypeLookupable, returnTypeValue.getComponentType())) {
            FilterSpecCompilerMakeParamUtil.throwConversionError(returnTypeValue.getComponentType(), returnTypeLookupable, propertyName);
        }
    }

    private static FilterSpecParam handleEqualsAndRelOp(ExprNode constituent, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, ExprEvaluatorContext exprEvaluatorContext, String statementName) throws ExprValidationException {
        FilterSpecLookupable lookupable;
        ExprContextPropertyNode ctxNode;
        ExprFilterOptimizableNode filterOptimizableNode;
        FilterOperator op;
        if (constituent instanceof ExprEqualsNode) {
            ExprEqualsNode equalsNode = (ExprEqualsNode)constituent;
            if (!equalsNode.isIs()) {
                op = FilterOperator.EQUAL;
                if (equalsNode.isNotEquals()) {
                    op = FilterOperator.NOT_EQUAL;
                }
            } else {
                op = FilterOperator.IS;
                if (equalsNode.isNotEquals()) {
                    op = FilterOperator.IS_NOT;
                }
            }
        } else {
            ExprRelationalOpNode relNode = (ExprRelationalOpNode)constituent;
            if (relNode.getRelationalOpEnum() == RelationalOpEnum.GT) {
                op = FilterOperator.GREATER;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LT) {
                op = FilterOperator.LESS;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LE) {
                op = FilterOperator.LESS_OR_EQUAL;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.GE) {
                op = FilterOperator.GREATER_OR_EQUAL;
            } else {
                throw new IllegalStateException("Opertor '" + (Object)((Object)relNode.getRelationalOpEnum()) + "' not mapped");
            }
        }
        ExprNode left = constituent.getChildNodes()[0];
        ExprNode right = constituent.getChildNodes()[1];
        if (ExprNodeUtility.isConstantValueExpr(right) && left instanceof ExprFilterOptimizableNode && (filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left)).getFilterLookupEligible()) {
            ExprConstantNode constantNode = (ExprConstantNode)right;
            FilterSpecLookupable lookupable2 = filterOptimizableNode.getFilterLookupable();
            Object constant = constantNode.getConstantValue(exprEvaluatorContext);
            constant = FilterSpecCompilerMakeParamUtil.handleConstantsCoercion(lookupable2, constant);
            return new FilterSpecParamConstant(lookupable2, op, constant);
        }
        if (ExprNodeUtility.isConstantValueExpr(left) && right instanceof ExprFilterOptimizableNode && (filterOptimizableNode = (ExprFilterOptimizableNode)((Object)right)).getFilterLookupEligible()) {
            ExprConstantNode constantNode = (ExprConstantNode)left;
            FilterSpecLookupable lookupable3 = filterOptimizableNode.getFilterLookupable();
            Object constant = constantNode.getConstantValue(exprEvaluatorContext);
            constant = FilterSpecCompilerMakeParamUtil.handleConstantsCoercion(lookupable3, constant);
            FilterOperator opReversed = op.isComparisonOperator() ? op.reversedRelationalOp() : op;
            return new FilterSpecParamConstant(lookupable3, opReversed, constant);
        }
        if (left instanceof ExprIdentNode && right instanceof ExprIdentNode) {
            ExprIdentNode identNodeLeft = (ExprIdentNode)left;
            ExprIdentNode identNodeRight = (ExprIdentNode)right;
            if (identNodeLeft.getStreamId() == 0 && identNodeLeft.getFilterLookupEligible() && identNodeRight.getStreamId() != 0) {
                return FilterSpecCompilerMakeParamUtil.handleProperty(op, identNodeLeft, identNodeRight, arrayEventTypes, statementName);
            }
            if (identNodeRight.getStreamId() == 0 && identNodeRight.getFilterLookupEligible() && identNodeLeft.getStreamId() != 0) {
                op = FilterSpecCompilerMakeParamUtil.getReversedOperator(constituent, op);
                return FilterSpecCompilerMakeParamUtil.handleProperty(op, identNodeRight, identNodeLeft, arrayEventTypes, statementName);
            }
        }
        if (left instanceof ExprFilterOptimizableNode && right instanceof ExprContextPropertyNode) {
            filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
            ctxNode = (ExprContextPropertyNode)right;
            lookupable = filterOptimizableNode.getFilterLookupable();
            if (filterOptimizableNode.getFilterLookupEligible()) {
                SimpleNumberCoercer numberCoercer = FilterSpecCompilerMakeParamUtil.getNumberCoercer(lookupable.getReturnType(), ctxNode.getType(), lookupable.getExpression());
                return new FilterSpecParamContextProp(lookupable, op, ctxNode.getPropertyName(), ctxNode.getGetter(), numberCoercer);
            }
        }
        if (left instanceof ExprContextPropertyNode && right instanceof ExprFilterOptimizableNode) {
            filterOptimizableNode = (ExprFilterOptimizableNode)((Object)right);
            ctxNode = (ExprContextPropertyNode)left;
            lookupable = filterOptimizableNode.getFilterLookupable();
            if (filterOptimizableNode.getFilterLookupEligible()) {
                op = FilterSpecCompilerMakeParamUtil.getReversedOperator(constituent, op);
                SimpleNumberCoercer numberCoercer = FilterSpecCompilerMakeParamUtil.getNumberCoercer(lookupable.getReturnType(), ctxNode.getType(), lookupable.getExpression());
                return new FilterSpecParamContextProp(lookupable, op, ctxNode.getPropertyName(), ctxNode.getGetter(), numberCoercer);
            }
        }
        return null;
    }

    private static FilterOperator getReversedOperator(ExprNode constituent, FilterOperator op) {
        if (!(constituent instanceof ExprRelationalOpNode)) {
            return op;
        }
        ExprRelationalOpNode relNode = (ExprRelationalOpNode)constituent;
        RelationalOpEnum relationalOpEnum = relNode.getRelationalOpEnum();
        if (relationalOpEnum == RelationalOpEnum.GT) {
            return FilterOperator.LESS;
        }
        if (relationalOpEnum == RelationalOpEnum.LT) {
            return FilterOperator.GREATER;
        }
        if (relationalOpEnum == RelationalOpEnum.LE) {
            return FilterOperator.GREATER_OR_EQUAL;
        }
        if (relationalOpEnum == RelationalOpEnum.GE) {
            return FilterOperator.LESS_OR_EQUAL;
        }
        return op;
    }

    private static FilterSpecParam handleProperty(FilterOperator op, ExprIdentNode identNodeLeft, ExprIdentNode identNodeRight, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, String statementName) throws ExprValidationException {
        Class rightType;
        String propertyName = identNodeLeft.getResolvedPropertyName();
        Class leftType = identNodeLeft.getExprEvaluator().getType();
        SimpleNumberCoercer numberCoercer = FilterSpecCompilerMakeParamUtil.getNumberCoercer(leftType, rightType = identNodeRight.getExprEvaluator().getType(), propertyName);
        boolean isMustCoerce = numberCoercer != null;
        Class numericCoercionType = JavaClassHelper.getBoxedType(leftType);
        String streamName = identNodeRight.getResolvedStreamName();
        if (arrayEventTypes != null && !arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(streamName)) {
            Pair<Integer, String> indexAndProp = FilterSpecCompilerMakeParamUtil.getStreamIndex(identNodeRight.getResolvedPropertyName());
            return new FilterSpecParamEventPropIndexed(identNodeLeft.getFilterLookupable(), op, identNodeRight.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), isMustCoerce, numberCoercer, numericCoercionType, statementName);
        }
        return new FilterSpecParamEventProp(identNodeLeft.getFilterLookupable(), op, identNodeRight.getResolvedStreamName(), identNodeRight.getResolvedPropertyName(), isMustCoerce, numberCoercer, numericCoercionType, statementName);
    }

    private static SimpleNumberCoercer getNumberCoercer(Class leftType, Class rightType, String expression) throws ExprValidationException {
        Class numericCoercionType = JavaClassHelper.getBoxedType(leftType);
        if (rightType != leftType && JavaClassHelper.isNumeric(rightType)) {
            if (!JavaClassHelper.canCoerce(rightType, leftType)) {
                FilterSpecCompilerMakeParamUtil.throwConversionError(rightType, leftType, expression);
            }
            return SimpleNumberCoercerFactory.getCoercer(rightType, numericCoercionType);
        }
        return null;
    }

    private static Pair<Integer, String> getStreamIndex(String resolvedPropertyName) {
        Property property = PropertyParser.parseAndWalkLaxToSimple(resolvedPropertyName);
        if (!(property instanceof NestedProperty)) {
            throw new IllegalStateException("Expected a nested property providing an index for array match '" + resolvedPropertyName + "'");
        }
        NestedProperty nested = (NestedProperty)property;
        if (nested.getProperties().size() < 2) {
            throw new IllegalStateException("Expected a nested property name for array match '" + resolvedPropertyName + "', none found");
        }
        if (!(nested.getProperties().get(0) instanceof IndexedProperty)) {
            throw new IllegalStateException("Expected an indexed property for array match '" + resolvedPropertyName + "', please provide an index");
        }
        int index = ((IndexedProperty)nested.getProperties().get(0)).getIndex();
        nested.getProperties().remove(0);
        StringWriter writer = new StringWriter();
        nested.toPropertyEPL(writer);
        return new Pair<Integer, String>(index, writer.toString());
    }

    private static void throwConversionError(Class fromType, Class toType, String propertyName) throws ExprValidationException {
        String text = "Implicit conversion from datatype '" + fromType.getSimpleName() + "' to '" + toType.getSimpleName() + "' for property '" + propertyName + "' is not allowed (strict filter type coercion)";
        throw new ExprValidationException(text);
    }

    private static Object handleConstantsCoercion(FilterSpecLookupable lookupable, Object constant) throws ExprValidationException {
        Class identNodeType = lookupable.getReturnType();
        if (!JavaClassHelper.isNumeric(identNodeType)) {
            return constant;
        }
        if (constant == null) {
            return null;
        }
        if (!JavaClassHelper.canCoerce(constant.getClass(), identNodeType)) {
            FilterSpecCompilerMakeParamUtil.throwConversionError(constant.getClass(), identNodeType, lookupable.getExpression());
        }
        Class identNodeTypeBoxed = JavaClassHelper.getBoxedType(identNodeType);
        return JavaClassHelper.coerceBoxed((Number)constant, identNodeTypeBoxed);
    }

    private static boolean isExprExistsInAllEqualsChildNodes(ExprNode[] childNodes, ExprNode search) {
        for (ExprNode child : childNodes) {
            ExprNode lhs = child.getChildNodes()[0];
            ExprNode rhs = child.getChildNodes()[1];
            if (!ExprNodeUtility.deepEquals(lhs, search) && !ExprNodeUtility.deepEquals(rhs, search)) {
                return false;
            }
            if (!ExprNodeUtility.deepEquals(lhs, rhs)) continue;
            return false;
        }
        return true;
    }
}

