/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamInValue;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class FilterSpecParamIn
extends FilterSpecParam {
    private final List<FilterSpecParamInValue> listOfValues;
    private MultiKeyUntyped inListConstantsOnly;
    private boolean hasCollMapOrArray;
    private InValueAdder[] adders;
    private static final long serialVersionUID = 1723225284589047752L;

    public FilterSpecParamIn(FilterSpecLookupable lookupable, FilterOperator filterOperator, List<FilterSpecParamInValue> listofValues) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        this.listOfValues = listofValues;
        for (FilterSpecParamInValue value : listofValues) {
            Class returnType = value.getReturnType();
            if (!JavaClassHelper.isCollectionMapOrArray(returnType)) continue;
            this.hasCollMapOrArray = true;
            break;
        }
        if (this.hasCollMapOrArray) {
            this.adders = new InValueAdder[listofValues.size()];
            for (int i = 0; i < listofValues.size(); ++i) {
                Class returnType = listofValues.get(0).getReturnType();
                this.adders[i] = returnType == null ? InValueAdderPlain.INSTANCE : (returnType.isArray() ? InValueAdderArray.INSTANCE : (JavaClassHelper.isImplementsInterface(returnType, Map.class) ? InValueAdderMap.INSTANCE : (JavaClassHelper.isImplementsInterface(returnType, Collection.class) ? InValueAdderColl.INSTANCE : InValueAdderPlain.INSTANCE)));
            }
        }
        boolean isAllConstants = true;
        for (FilterSpecParamInValue value : listofValues) {
            if (value.constant()) continue;
            isAllConstants = false;
            break;
        }
        if (isAllConstants) {
            this.inListConstantsOnly = this.getFilterValues(null, null);
        }
        if (filterOperator != FilterOperator.IN_LIST_OF_VALUES && filterOperator != FilterOperator.NOT_IN_LIST_OF_VALUES) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to in-values filter parameter");
        }
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents, AgentInstanceContext agentInstanceContext) {
        if (this.inListConstantsOnly != null) {
            return this.inListConstantsOnly;
        }
        return this.getFilterValues(matchedEvents, agentInstanceContext);
    }

    public List<FilterSpecParamInValue> getListOfValues() {
        return this.listOfValues;
    }

    @Override
    public final String toString() {
        return super.toString() + "  in=(listOfValues=" + this.listOfValues.toString() + ')';
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamIn)) {
            return false;
        }
        FilterSpecParamIn other = (FilterSpecParamIn)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.listOfValues.size() != other.listOfValues.size()) {
            return false;
        }
        return Arrays.deepEquals(this.listOfValues.toArray(), other.listOfValues.toArray());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.listOfValues != null ? this.listOfValues.hashCode() : 0);
        return result;
    }

    private MultiKeyUntyped getFilterValues(MatchedEventMap matchedEvents, AgentInstanceContext agentInstanceContext) {
        if (!this.hasCollMapOrArray) {
            Object[] constants = new Object[this.listOfValues.size()];
            int count = 0;
            for (FilterSpecParamInValue valuePlaceholder : this.listOfValues) {
                constants[count++] = valuePlaceholder.getFilterValue(matchedEvents, agentInstanceContext);
            }
            return new MultiKeyUntyped(constants);
        }
        ArrayDeque<Object> constants = new ArrayDeque<Object>(this.listOfValues.size());
        int count = 0;
        for (FilterSpecParamInValue valuePlaceholder : this.listOfValues) {
            Object value = valuePlaceholder.getFilterValue(matchedEvents, agentInstanceContext);
            if (value != null) {
                this.adders[count].add(constants, value);
            }
            ++count;
        }
        return new MultiKeyUntyped(constants.toArray());
    }

    private static class InValueAdderPlain
    implements InValueAdder {
        private static final InValueAdderPlain INSTANCE = new InValueAdderPlain();

        private InValueAdderPlain() {
        }

        @Override
        public void add(Collection<Object> constants, Object value) {
            constants.add(value);
        }
    }

    private static class InValueAdderColl
    implements InValueAdder {
        private static final InValueAdderColl INSTANCE = new InValueAdderColl();

        private InValueAdderColl() {
        }

        @Override
        public void add(Collection<Object> constants, Object value) {
            Collection coll = (Collection)value;
            constants.addAll(coll);
        }
    }

    private static class InValueAdderMap
    implements InValueAdder {
        private static final InValueAdderMap INSTANCE = new InValueAdderMap();

        private InValueAdderMap() {
        }

        @Override
        public void add(Collection<Object> constants, Object value) {
            Map map = (Map)value;
            constants.addAll(map.keySet());
        }
    }

    private static class InValueAdderArray
    implements InValueAdder {
        private static final InValueAdderArray INSTANCE = new InValueAdderArray();

        private InValueAdderArray() {
        }

        @Override
        public void add(Collection<Object> constants, Object value) {
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                constants.add(Array.get(value, i));
            }
        }
    }

    private static interface InValueAdder {
        public void add(Collection<Object> var1, Object var2);
    }
}

