/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterSpecParamInValue;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.util.JavaClassHelper;

public class InSetOfValuesEventProp
implements FilterSpecParamInValue {
    private final String resultEventAsName;
    private final String resultEventProperty;
    private final boolean isMustCoerce;
    private final Class coercionType;
    private static final long serialVersionUID = -2806996166528183416L;

    public InSetOfValuesEventProp(String resultEventAsName, String resultEventProperty, boolean isMustCoerce, Class coercionType) {
        this.resultEventAsName = resultEventAsName;
        this.resultEventProperty = resultEventProperty;
        this.coercionType = coercionType;
        this.isMustCoerce = isMustCoerce;
    }

    @Override
    public Class getReturnType() {
        return this.coercionType;
    }

    @Override
    public boolean constant() {
        return false;
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext) {
        EventBean theEvent = matchedEvents.getMatchingEventByTag(this.resultEventAsName);
        if (theEvent == null) {
            throw new IllegalStateException("Matching event named '" + this.resultEventAsName + "' not found in event result set");
        }
        Object value = theEvent.get(this.resultEventProperty);
        if (this.isMustCoerce && value != null) {
            value = JavaClassHelper.coerceBoxed((Number)value, this.coercionType);
        }
        return value;
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    public final String toString() {
        return "resultEventProp=" + this.resultEventAsName + '.' + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InSetOfValuesEventProp)) {
            return false;
        }
        InSetOfValuesEventProp other = (InSetOfValuesEventProp)obj;
        return other.resultEventAsName.equals(this.resultEventAsName) && other.resultEventProperty.equals(this.resultEventProperty);
    }

    public int hashCode() {
        return this.resultEventProperty.hashCode();
    }
}

