/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.filter.FilterSpecParamInValue;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.util.JavaClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InSetOfValuesEventPropIndexed
implements FilterSpecParamInValue {
    private static final Logger log = LoggerFactory.getLogger(InSetOfValuesEventPropIndexed.class);
    private final String resultEventAsName;
    private final int resultEventIndex;
    private final String resultEventProperty;
    private final boolean isMustCoerce;
    private final Class coercionType;
    private final String statementName;
    private static final long serialVersionUID = -4424097388643812241L;

    public InSetOfValuesEventPropIndexed(String resultEventAsName, int resultEventindex, String resultEventProperty, boolean isMustCoerce, Class coercionType, String statementName) {
        this.resultEventAsName = resultEventAsName;
        this.resultEventProperty = resultEventProperty;
        this.resultEventIndex = resultEventindex;
        this.coercionType = coercionType;
        this.isMustCoerce = isMustCoerce;
        this.statementName = statementName;
    }

    @Override
    public Class getReturnType() {
        return this.coercionType;
    }

    @Override
    public boolean constant() {
        return false;
    }

    @Override
    public Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext) {
        EventBean[] events = (EventBean[])matchedEvents.getMatchingEventAsObjectByTag(this.resultEventAsName);
        Object value = null;
        if (events == null) {
            log.warn("Matching events for tag '" + this.resultEventAsName + "' returned a null result, using null value in filter criteria, for statement '" + this.statementName + "'");
        } else if (this.resultEventIndex > events.length - 1) {
            log.warn("Matching events for tag '" + this.resultEventAsName + "' returned no result for index " + this.resultEventIndex + " at array length " + events.length + ", using null value in filter criteria, for statement '" + this.statementName + "'");
        } else {
            value = events[this.resultEventIndex].get(this.resultEventProperty);
        }
        if (this.isMustCoerce) {
            value = JavaClassHelper.coerceBoxed((Number)value, this.coercionType);
        }
        return value;
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    public final String toString() {
        return "resultEventProp=" + this.resultEventAsName + '.' + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InSetOfValuesEventPropIndexed)) {
            return false;
        }
        InSetOfValuesEventPropIndexed other = (InSetOfValuesEventPropIndexed)obj;
        return other.resultEventAsName.equals(this.resultEventAsName) && other.resultEventProperty.equals(this.resultEventProperty);
    }

    public int hashCode() {
        return this.resultEventProperty.hashCode();
    }
}

