/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.filter.Range;

public final class StringRange
implements Range {
    private String min;
    private String max;
    private int hashCode;

    public StringRange(String min, String max) {
        this.min = min;
        this.max = max;
        if (min != null && max != null && min.compareTo(max) > 0) {
            this.max = min;
            this.min = max;
        }
        this.hashCode = 7;
        if (min != null) {
            this.hashCode = 31 * this.hashCode;
            this.hashCode ^= min.hashCode();
        }
        if (max != null) {
            this.hashCode = 31 * this.hashCode;
            this.hashCode ^= max.hashCode();
        }
    }

    @Override
    public Object getLowEndpoint() {
        return this.min;
    }

    @Override
    public Object getHighEndpoint() {
        return this.max;
    }

    public final String getMin() {
        return this.min;
    }

    public final String getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringRange that = (StringRange)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        if (this.max != null ? !this.max.equals(that.max) : that.max != null) {
            return false;
        }
        return !(this.min != null ? !this.min.equals(that.min) : that.min != null);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return "StringRange min=" + this.min + " max=" + this.max;
    }
}

