/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalEveryNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeFactoryBase;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalEveryDistinctFactoryNode
extends EvalNodeFactoryBase {
    protected List<ExprNode> expressions;
    protected transient ExprEvaluator[] distinctExpressionsArray;
    private transient MatchedEventConvertor convertor;
    private ExprTimePeriodEvalDeltaConst timeDeltaComputation;
    private ExprNode expiryTimeExp;
    protected List<ExprNode> distinctExpressions;
    private static final long serialVersionUID = 7455570958072753956L;
    private static final Logger log = LoggerFactory.getLogger(EvalEveryNode.class);

    protected EvalEveryDistinctFactoryNode(List<ExprNode> expressions) {
        this.expressions = expressions;
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        if (this.distinctExpressionsArray == null) {
            this.distinctExpressionsArray = ExprNodeUtility.getEvaluators(this.distinctExpressions);
        }
        EvalNode child = EvalNodeUtil.makeEvalNodeSingleChild(this.getChildNodes(), agentInstanceContext, parentNode);
        return new EvalEveryDistinctNode(this, child, agentInstanceContext);
    }

    public ExprEvaluator[] getDistinctExpressionsArray() {
        return this.distinctExpressionsArray;
    }

    public MatchedEventConvertor getConvertor() {
        return this.convertor;
    }

    public final String toString() {
        return "EvalEveryNode children=" + this.getChildNodes().size();
    }

    public List<ExprNode> getExpressions() {
        return this.expressions;
    }

    public List<ExprNode> getDistinctExpressions() {
        return this.distinctExpressions;
    }

    public void setConvertor(MatchedEventConvertor convertor) {
        this.convertor = convertor;
    }

    public void setDistinctExpressions(List<ExprNode> distinctExpressions, ExprTimePeriodEvalDeltaConst timeDeltaComputation, ExprNode expiryTimeExp) {
        this.distinctExpressions = distinctExpressions;
        this.timeDeltaComputation = timeDeltaComputation;
        this.expiryTimeExp = expiryTimeExp;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    public long absExpiry(PatternAgentInstanceContext context) {
        long current = context.getStatementContext().getSchedulingService().getTime();
        return current + this.timeDeltaComputation.deltaAdd(current);
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("every-distinct(");
        ExprNodeUtility.toExpressionStringParameterList(this.distinctExpressions, writer);
        if (this.expiryTimeExp != null) {
            writer.append(",");
            writer.append(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this.expiryTimeExp));
        }
        writer.append(") ");
        this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.UNARY;
    }
}

