/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.spec.PatternGuardSpec;
import com.espertech.esper.pattern.EvalGuardNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeFactoryBase;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import com.espertech.esper.pattern.guard.GuardEnum;
import com.espertech.esper.pattern.guard.GuardFactory;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalGuardFactoryNode
extends EvalNodeFactoryBase {
    private static final long serialVersionUID = -6426206281275755119L;
    private PatternGuardSpec patternGuardSpec;
    private transient GuardFactory guardFactory;
    private static final Logger log = LoggerFactory.getLogger(EvalGuardFactoryNode.class);

    protected EvalGuardFactoryNode(PatternGuardSpec patternGuardSpec) {
        this.patternGuardSpec = patternGuardSpec;
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        EvalNode child = EvalNodeUtil.makeEvalNodeSingleChild(this.getChildNodes(), agentInstanceContext, parentNode);
        return new EvalGuardNode(agentInstanceContext, this, child);
    }

    public PatternGuardSpec getPatternGuardSpec() {
        return this.patternGuardSpec;
    }

    public void setGuardFactory(GuardFactory guardFactory) {
        this.guardFactory = guardFactory;
    }

    public GuardFactory getGuardFactory() {
        return this.guardFactory;
    }

    public final String toString() {
        return "EvalGuardNode guardFactory=" + this.guardFactory + "  children=" + this.getChildNodes().size();
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    public String toPrecedenceFreeEPL() {
        StringWriter writer = new StringWriter();
        this.toPrecedenceFreeEPL(writer);
        return writer.toString();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
        if (this.patternGuardSpec.getObjectNamespace().equals(GuardEnum.WHILE_GUARD.getNamespace()) && this.patternGuardSpec.getObjectName().equals(GuardEnum.WHILE_GUARD.getName())) {
            writer.write(" while ");
        } else {
            writer.write(" where ");
            writer.write(this.patternGuardSpec.getObjectNamespace());
            writer.write(":");
            writer.write(this.patternGuardSpec.getObjectName());
        }
        writer.write("(");
        ExprNodeUtility.toExpressionStringParameterList(this.patternGuardSpec.getObjectParameters(), writer);
        writer.write(")");
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.GUARD_POSTFIX;
    }
}

