/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalOrNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalOrStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalOrNode evalOrNode;
    protected final EvalStateNode[] childNodes;
    private static final Logger log = LoggerFactory.getLogger(EvalOrStateNode.class);

    public EvalOrStateNode(Evaluator parentNode, EvalOrNode evalOrNode) {
        super(parentNode);
        this.childNodes = new EvalStateNode[evalOrNode.getChildNodes().length];
        this.evalOrNode = evalOrNode;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        for (EvalStateNode node : this.childNodes) {
            if (node == null) continue;
            node.removeMatch(matchEvent);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalOrNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        int count = 0;
        for (EvalNode node : this.evalOrNode.getChildNodes()) {
            EvalStateNode childState = node.newState(this, null, 0L);
            this.childNodes[count++] = childState;
        }
        EvalStateNode[] childNodeCopy = new EvalStateNode[this.childNodes.length];
        System.arraycopy(this.childNodes, 0, childNodeCopy, 0, this.childNodes.length);
        for (EvalStateNode child : childNodeCopy) {
            child.start(beginState);
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        if (isQuitted) {
            for (int i = 0; i < this.childNodes.length; ++i) {
                if (this.childNodes[i] != fromNode) continue;
                this.childNodes[i] = null;
            }
            this.quitInternal();
        }
        this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        for (int i = 0; i < this.childNodes.length; ++i) {
            if (this.childNodes[i] != fromNode) continue;
            this.childNodes[i] = null;
        }
        boolean allEmpty = true;
        for (int i = 0; i < this.childNodes.length; ++i) {
            if (this.childNodes[i] == null) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            this.getParentEvaluator().evaluateFalse(this, true);
        }
    }

    @Override
    public final void quit() {
        this.quitInternal();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitOr(this.evalOrNode.getFactoryNode(), this);
        for (EvalStateNode node : this.childNodes) {
            if (node == null) continue;
            node.accept(visitor);
        }
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalOrStateNode";
    }

    private void quitInternal() {
        for (EvalStateNode child : this.childNodes) {
            if (child == null) continue;
            child.quit();
        }
        Arrays.fill(this.childNodes, null);
    }
}

