/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.MatchedEventMapMeta;
import java.util.HashMap;
import java.util.Map;

public final class MatchedEventMapImpl
implements MatchedEventMap {
    private final MatchedEventMapMeta meta;
    private final Object[] matches;

    public MatchedEventMapImpl(MatchedEventMapMeta meta) {
        this.meta = meta;
        this.matches = new Object[meta.getTagsPerIndex().length];
    }

    public MatchedEventMapImpl(MatchedEventMapMeta meta, Object[] matches) {
        this.meta = meta;
        this.matches = matches;
    }

    @Override
    public void add(int tag, Object theEvent) {
        this.matches[tag] = theEvent;
    }

    @Override
    public Object[] getMatchingEvents() {
        return this.matches;
    }

    @Override
    public EventBean getMatchingEvent(int tag) {
        return (EventBean)this.matches[tag];
    }

    @Override
    public Object getMatchingEventAsObject(int tag) {
        return this.matches[tag];
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (int i = 0; i < this.matches.length; ++i) {
            buffer.append(" (");
            buffer.append(count++);
            buffer.append(") ");
            buffer.append("tag=");
            buffer.append(this.meta.getTagsPerIndex()[i]);
            buffer.append("  event=");
            buffer.append(this.matches[i]);
        }
        return buffer.toString();
    }

    @Override
    public MatchedEventMapImpl shallowCopy() {
        if (this.matches.length == 0) {
            return this;
        }
        Object[] copy = new Object[this.matches.length];
        if (this.matches.length > 1) {
            System.arraycopy(this.matches, 0, copy, 0, this.matches.length);
        } else {
            copy[0] = this.matches[0];
        }
        return new MatchedEventMapImpl(this.meta, copy);
    }

    @Override
    public void merge(MatchedEventMap other) {
        if (!(other instanceof MatchedEventMapImpl)) {
            throw new UnsupportedOperationException("Merge requires same types");
        }
        MatchedEventMapImpl otherImpl = (MatchedEventMapImpl)other;
        for (int i = 0; i < this.matches.length; ++i) {
            if (otherImpl.matches[i] == null) continue;
            this.matches[i] = otherImpl.matches[i];
        }
    }

    @Override
    public Map<String, Object> getMatchingEventsAsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.meta.getTagsPerIndex().length; ++i) {
            if (this.matches[i] == null) continue;
            map.put(this.meta.getTagsPerIndex()[i], this.matches[i]);
        }
        return map;
    }

    @Override
    public MatchedEventMapMeta getMeta() {
        return this.meta;
    }

    @Override
    public EventBean getMatchingEventByTag(String resultEventAsName) {
        Object obj = this.getMatchingEventAsObjectByTag(resultEventAsName);
        return (EventBean)obj;
    }

    @Override
    public Object getMatchingEventAsObjectByTag(String key) {
        int index = this.meta.getTagFor(key);
        if (index == -1) {
            return null;
        }
        return this.matches[index];
    }
}

