/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.guard;

import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.guard.EventGuardVisitor;
import com.espertech.esper.pattern.guard.Guard;
import com.espertech.esper.pattern.guard.Quitable;
import com.espertech.esper.schedule.ScheduleHandleCallback;

public class TimerWithinGuard
implements Guard,
ScheduleHandleCallback {
    private final long deltaTime;
    private final Quitable quitable;
    private final long scheduleSlot;
    private boolean isTimerActive;
    private EPStatementHandleCallback scheduleHandle;

    public TimerWithinGuard(long delta, Quitable quitable) {
        this.deltaTime = delta;
        this.quitable = quitable;
        this.scheduleSlot = quitable.getContext().getPatternContext().getScheduleBucket().allocateSlot();
    }

    @Override
    public void startGuard() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        this.scheduleHandle = new EPStatementHandleCallback(this.quitable.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        this.quitable.getContext().getPatternContext().getSchedulingService().add(this.deltaTime, this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
    }

    @Override
    public void stopGuard() {
        if (this.isTimerActive) {
            this.quitable.getContext().getPatternContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.scheduleHandle = null;
            this.isTimerActive = false;
        }
    }

    @Override
    public boolean inspect(MatchedEventMap matchEvent) {
        return true;
    }

    @Override
    public final void scheduledTrigger(EngineLevelExtensionServicesContext engineLevelExtensionServicesContext) {
        this.isTimerActive = false;
        this.quitable.guardQuit();
    }

    @Override
    public void accept(EventGuardVisitor visitor) {
        visitor.visitGuard(10, this.scheduleSlot);
    }
}

