/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.guard;

import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.pattern.EvalStateNodeNumber;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionUtil;
import com.espertech.esper.pattern.guard.Guard;
import com.espertech.esper.pattern.guard.GuardFactory;
import com.espertech.esper.pattern.guard.GuardParameterException;
import com.espertech.esper.pattern.guard.Quitable;
import com.espertech.esper.pattern.guard.TimerWithinGuard;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.List;

public class TimerWithinGuardFactory
implements GuardFactory,
MetaDefItem,
Serializable {
    private static final long serialVersionUID = -1026320055174163611L;
    protected ExprNode timeExpr;
    protected transient MatchedEventConvertor convertor;

    @Override
    public void setGuardParameters(List<ExprNode> parameters, MatchedEventConvertor convertor) throws GuardParameterException {
        String errorMessage = "Timer-within guard requires a single numeric or time period parameter";
        if (parameters.size() != 1) {
            throw new GuardParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(parameters.get(0).getExprEvaluator().getType())) {
            throw new GuardParameterException(errorMessage);
        }
        this.convertor = convertor;
        this.timeExpr = parameters.get(0);
    }

    public long computeTime(MatchedEventMap beginState, PatternAgentInstanceContext context) {
        if (this.timeExpr instanceof ExprTimePeriod) {
            ExprTimePeriod timePeriod = (ExprTimePeriod)this.timeExpr;
            return timePeriod.nonconstEvaluator().deltaUseEngineTime(this.convertor.convert(beginState), context.getAgentInstanceContext());
        }
        Object time = PatternExpressionUtil.evaluate("Timer-within guard", beginState, this.timeExpr, this.convertor, (ExprEvaluatorContext)context.getAgentInstanceContext());
        if (time == null) {
            throw new EPException("Timer-within guard expression returned a null-value");
        }
        return context.getStatementContext().getTimeAbacus().deltaForSecondsNumber((Number)time);
    }

    @Override
    public Guard makeGuard(PatternAgentInstanceContext context, MatchedEventMap matchedEventMap, Quitable quitable, EvalStateNodeNumber stateNodeId, Object guardState) {
        return new TimerWithinGuard(this.computeTime(matchedEventMap, context), quitable);
    }
}

