/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.rowregex;

import com.espertech.esper.rowregex.RegexNFAStateEntry;
import com.espertech.esper.rowregex.RegexPartitionStateRepoScheduleState;
import com.espertech.esper.rowregex.RegexPartitionTerminationStateComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class RegexPartitionStateRepoScheduleStateImpl
implements RegexPartitionStateRepoScheduleState {
    private final RegexPartitionTerminationStateComparator terminationStateCompare;
    private final TreeMap<Long, Object> schedule = new TreeMap();

    public RegexPartitionStateRepoScheduleStateImpl(RegexPartitionTerminationStateComparator terminationStateCompare) {
        this.terminationStateCompare = terminationStateCompare;
    }

    @Override
    public boolean isEmpty() {
        return this.schedule.isEmpty();
    }

    @Override
    public boolean putOrAdd(long matchBeginTime, RegexNFAStateEntry state) {
        Object value = this.schedule.get(matchBeginTime);
        if (value == null) {
            this.schedule.put(matchBeginTime, state);
            return true;
        }
        if (value instanceof RegexNFAStateEntry) {
            RegexNFAStateEntry valueEntry = (RegexNFAStateEntry)value;
            ArrayList<RegexNFAStateEntry> list = new ArrayList<RegexNFAStateEntry>();
            list.add(valueEntry);
            list.add(state);
            this.schedule.put(matchBeginTime, list);
        } else {
            List list = (List)value;
            list.add(state);
        }
        return false;
    }

    public Object get(long matchBeginTime) {
        return this.schedule.get(matchBeginTime);
    }

    @Override
    public long firstKey() {
        return this.schedule.firstKey();
    }

    @Override
    public void removeAddRemoved(long matchBeginTime, List<RegexNFAStateEntry> foundStates) {
        Object found = this.schedule.remove(matchBeginTime);
        if (found == null) {
            return;
        }
        if (found instanceof RegexNFAStateEntry) {
            foundStates.add((RegexNFAStateEntry)found);
        } else {
            foundStates.addAll((List)found);
        }
    }

    @Override
    public boolean containsKey(long matchBeginTime) {
        return this.schedule.containsKey(matchBeginTime);
    }

    @Override
    public boolean findRemoveAddToList(long matchBeginTime, RegexNFAStateEntry state, List<RegexNFAStateEntry> foundStates) {
        Object entry = this.schedule.get(matchBeginTime);
        if (entry == null) {
            return false;
        }
        if (entry instanceof RegexNFAStateEntry) {
            RegexNFAStateEntry single = (RegexNFAStateEntry)entry;
            if (this.terminationStateCompare.compareTerminationStateToEndState(state, single)) {
                this.schedule.remove(matchBeginTime);
                foundStates.add(single);
                return true;
            }
            return false;
        }
        List entries = (List)entry;
        Iterator it = entries.iterator();
        boolean removed = false;
        while (it.hasNext()) {
            RegexNFAStateEntry endState = (RegexNFAStateEntry)it.next();
            if (!this.terminationStateCompare.compareTerminationStateToEndState(state, endState)) continue;
            it.remove();
            foundStates.add(endState);
            removed = true;
        }
        if (entries.isEmpty()) {
            this.schedule.remove(matchBeginTime);
        }
        return removed;
    }
}

