/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.rowregex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.rowregex.EventRowRegexNFAViewUtil;
import com.espertech.esper.rowregex.RegexNFAStateEntry;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class RegexPartitionTerminationStateComparator
implements Comparator<RegexNFAStateEntry> {
    private final int[] multimatchStreamNumToVariable;
    private final LinkedHashMap<String, Pair<Integer, Boolean>> variableStreams;

    public RegexPartitionTerminationStateComparator(int[] multimatchStreamNumToVariable, LinkedHashMap<String, Pair<Integer, Boolean>> variableStreams) {
        this.multimatchStreamNumToVariable = multimatchStreamNumToVariable;
        this.variableStreams = variableStreams;
    }

    @Override
    public int compare(RegexNFAStateEntry o1, RegexNFAStateEntry o2) {
        return this.compareTerminationStateToEndState(o1, o2) ? 0 : 1;
    }

    public boolean compareTerminationStateToEndState(RegexNFAStateEntry terminationState, RegexNFAStateEntry endState) {
        if (terminationState.getMatchBeginEventSeqNo() != endState.getMatchBeginEventSeqNo()) {
            return false;
        }
        for (Map.Entry<String, Pair<Integer, Boolean>> entry : this.variableStreams.entrySet()) {
            int stream = entry.getValue().getFirst();
            boolean multi = entry.getValue().getSecond();
            if (multi) {
                EventBean[] termStreamEvents = EventRowRegexNFAViewUtil.getMultimatchArray(this.multimatchStreamNumToVariable, terminationState, stream);
                EventBean[] endStreamEvents = EventRowRegexNFAViewUtil.getMultimatchArray(this.multimatchStreamNumToVariable, endState, stream);
                if (endStreamEvents == null) continue;
                if (termStreamEvents == null) {
                    return false;
                }
                for (int i = 0; i < endStreamEvents.length; ++i) {
                    if (termStreamEvents.length <= i || EventBeanUtility.eventsAreEqualsAllowNull(endStreamEvents[i], termStreamEvents[i])) continue;
                    return false;
                }
                continue;
            }
            EventBean termStreamEvent = terminationState.getEventsPerStream()[stream];
            EventBean endStreamEvent = endState.getEventsPerStream()[stream];
            if (EventBeanUtility.eventsAreEqualsAllowNull(endStreamEvent, termStreamEvent)) continue;
            return false;
        }
        return true;
    }
}

