/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.timer;

import com.espertech.esper.timer.EPLTimerTask;
import com.espertech.esper.timer.TimerCallback;
import com.espertech.esper.timer.TimerService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimerServiceImpl
implements TimerService {
    private final String engineURI;
    private final long msecTimerResolution;
    private TimerCallback timerCallback;
    private ScheduledThreadPoolExecutor timer;
    private EPLTimerTask timerTask;
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private final int id;
    private static final Logger log = LoggerFactory.getLogger(TimerServiceImpl.class);

    public TimerServiceImpl(String engineURI, long msecTimerResolution) {
        this.engineURI = engineURI;
        this.msecTimerResolution = msecTimerResolution;
        this.id = NEXT_ID.getAndIncrement();
    }

    public long getMsecTimerResolution() {
        return this.msecTimerResolution;
    }

    @Override
    public void setCallback(TimerCallback timerCallback) {
        this.timerCallback = timerCallback;
    }

    @Override
    public final void startInternalClock() {
        if (this.timer != null) {
            log.warn(".startInternalClock Internal clock is already started, stop first before starting, operation not completed");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(".startInternalClock Starting internal clock daemon thread, resolution=" + this.msecTimerResolution);
        }
        if (this.timerCallback == null) {
            throw new IllegalStateException("Timer callback not set");
        }
        this.getScheduledThreadPoolExecutorDaemonThread();
        this.timerTask = new EPLTimerTask(this.timerCallback);
        ScheduledFuture<?> future = this.timer.scheduleAtFixedRate(this.timerTask, 0L, this.msecTimerResolution, TimeUnit.MILLISECONDS);
        this.timerTask.setFuture(future);
    }

    @Override
    public final void stopInternalClock(boolean warnIfNotStarted) {
        if (this.timer == null) {
            if (warnIfNotStarted) {
                log.warn(".stopInternalClock Internal clock is already stopped, start first before stopping, operation not completed");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(".stopInternalClock Stopping internal clock daemon thread");
        }
        this.timer.shutdown();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            log.info("Timer start wait interval interruped");
        }
        this.timer = null;
    }

    @Override
    public void enableStats() {
        if (this.timerTask != null) {
            this.timerTask.enableStats = true;
        }
    }

    @Override
    public void disableStats() {
        if (this.timerTask != null) {
            this.timerTask.enableStats = false;
            this.timerTask.resetStats();
        }
    }

    @Override
    public long getMaxDrift() {
        return this.timerTask.maxDrift;
    }

    @Override
    public long getLastDrift() {
        return this.timerTask.lastDrift;
    }

    @Override
    public long getTotalDrift() {
        return this.timerTask.totalDrift;
    }

    @Override
    public long getInvocationCount() {
        return this.timerTask.invocationCount;
    }

    private void getScheduledThreadPoolExecutorDaemonThread() {
        this.timer = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String uri = TimerServiceImpl.this.engineURI;
                if (TimerServiceImpl.this.engineURI == null) {
                    uri = "default";
                }
                Thread t = new Thread(r, "com.espertech.esper.Timer-" + uri + "-" + TimerServiceImpl.this.id);
                t.setDaemon(true);
                return t;
            }
        });
        this.timer.setMaximumPoolSize(this.timer.getCorePoolSize());
        this.timer.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.timer.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
    }
}

