/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

import com.espertech.esper.type.PrimitiveValueBase;
import com.espertech.esper.type.PrimitiveValueType;

public final class LongValue
extends PrimitiveValueBase {
    private Long longValue;

    @Override
    public PrimitiveValueType getType() {
        return PrimitiveValueType.LONG;
    }

    @Override
    public final void parse(String value) {
        this.longValue = LongValue.parseString(value);
    }

    public static long parseString(String value) {
        if (value.endsWith("L") || value.endsWith("l")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.startsWith("+")) {
            value = value.substring(1);
        }
        return Long.parseLong(value);
    }

    public static long[] parseString(String[] values) {
        long[] result = new long[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = LongValue.parseString(values[i]);
        }
        return result;
    }

    @Override
    public final Object getValueObject() {
        return this.longValue;
    }

    @Override
    public final void setLong(long x) {
        this.longValue = x;
    }

    public final long getLong() {
        if (this.longValue == null) {
            throw new IllegalStateException();
        }
        return this.longValue;
    }

    public final String toString() {
        if (this.longValue == null) {
            return "null";
        }
        return this.longValue.toString();
    }
}

