/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import java.math.BigDecimal;
import java.math.BigInteger;

public enum MinMaxTypeEnum {
    MAX("max"),
    MIN("min");

    private String expressionText;

    private MinMaxTypeEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public static class ComputerBigDecCoerce
    implements Computer {
        private ExprEvaluator[] childNodes;
        private SimpleNumberBigDecimalCoercer[] convertors;
        private boolean isMax;

        public ComputerBigDecCoerce(ExprEvaluator[] childNodes, SimpleNumberBigDecimalCoercer[] convertors, boolean isMax) {
            this.childNodes = childNodes;
            this.convertors = convertors;
            this.isMax = isMax;
        }

        @Override
        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            BigDecimal bigDecOne = this.convertors[0].coerceBoxedBigDec(valueChildOne);
            BigDecimal bigDecTwo = this.convertors[1].coerceBoxedBigDec(valueChildTwo);
            BigDecimal result = this.isMax && bigDecOne.compareTo(bigDecTwo) > 0 || !this.isMax && bigDecOne.compareTo(bigDecTwo) < 0 ? bigDecOne : bigDecTwo;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                BigDecimal bigDec = this.convertors[i].coerceBoxedBigDec(valueChild);
                if ((!this.isMax || result.compareTo(bigDec) >= 0) && (this.isMax || result.compareTo(bigDec) <= 0)) continue;
                result = bigDec;
            }
            return result;
        }
    }

    public static class ComputerBigIntCoerce
    implements Computer {
        private ExprEvaluator[] childNodes;
        private SimpleNumberBigIntegerCoercer[] convertors;
        private boolean isMax;

        public ComputerBigIntCoerce(ExprEvaluator[] childNodes, SimpleNumberBigIntegerCoercer[] convertors, boolean isMax) {
            this.childNodes = childNodes;
            this.convertors = convertors;
            this.isMax = isMax;
        }

        @Override
        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            BigInteger bigIntOne = this.convertors[0].coerceBoxedBigInt(valueChildOne);
            BigInteger bigIntTwo = this.convertors[1].coerceBoxedBigInt(valueChildTwo);
            BigInteger result = this.isMax && bigIntOne.compareTo(bigIntTwo) > 0 || !this.isMax && bigIntOne.compareTo(bigIntTwo) < 0 ? bigIntOne : bigIntTwo;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                BigInteger bigInt = this.convertors[i].coerceBoxedBigInt(valueChild);
                if ((!this.isMax || result.compareTo(bigInt) >= 0) && (this.isMax || result.compareTo(bigInt) <= 0)) continue;
                result = bigInt;
            }
            return result;
        }
    }

    public static class MaxComputerDoubleCoerce
    implements Computer {
        private ExprEvaluator[] childNodes;

        public MaxComputerDoubleCoerce(ExprEvaluator[] childNodes) {
            this.childNodes = childNodes;
        }

        @Override
        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            Number result = valueChildOne.doubleValue() > valueChildTwo.doubleValue() ? (Number)valueChildOne : (Number)valueChildTwo;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                if (!(valueChild.doubleValue() > result.doubleValue())) continue;
                result = valueChild;
            }
            return result;
        }
    }

    public static class MinComputerDoubleCoerce
    implements Computer {
        private ExprEvaluator[] childNodes;

        public MinComputerDoubleCoerce(ExprEvaluator[] childNodes) {
            this.childNodes = childNodes;
        }

        @Override
        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            Number result = valueChildOne.doubleValue() > valueChildTwo.doubleValue() ? (Number)valueChildTwo : (Number)valueChildOne;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                if (!(valueChild.doubleValue() < result.doubleValue())) continue;
                result = valueChild;
            }
            return result;
        }
    }

    public static interface Computer {
        public Number execute(EventBean[] var1, boolean var2, ExprEvaluatorContext var3);
    }
}

