/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.util.DatabaseTypeBinding;
import com.espertech.esper.util.JavaClassHelper;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum DatabaseTypeEnum {
    String(String.class),
    BigDecimal(BigDecimal.class),
    Boolean(Boolean.class),
    Byte(Byte.class),
    Short(Short.class),
    Int(Integer.class),
    Long(Long.class),
    Float(Float.class),
    Double(Double.class),
    ByteArray(byte[].class),
    SqlDate(Date.class),
    SqlTime(Time.class),
    SqlTimestamp(Timestamp.class);

    private Class javaClass;
    private static Map<DatabaseTypeEnum, DatabaseTypeBinding> bindings;

    private DatabaseTypeEnum(Class javaClass) {
        this.javaClass = javaClass;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public static DatabaseTypeEnum getEnum(String type) {
        String boxedType = JavaClassHelper.getBoxedClassName(type);
        for (DatabaseTypeEnum val : DatabaseTypeEnum.values()) {
            if (val.toString().toLowerCase(Locale.ENGLISH).equals(type.toLowerCase(Locale.ENGLISH))) {
                return val;
            }
            if (val.getJavaClass().getName().toLowerCase(Locale.ENGLISH).equals(type.toLowerCase(Locale.ENGLISH))) {
                return val;
            }
            if (val.getJavaClass().getName().toLowerCase(Locale.ENGLISH).equals(boxedType)) {
                return val;
            }
            if (!val.getJavaClass().getSimpleName().toLowerCase(Locale.ENGLISH).equals(boxedType)) continue;
            return val;
        }
        return null;
    }

    public DatabaseTypeBinding getBinding() {
        return bindings.get((Object)this);
    }

    static {
        bindings = new HashMap<DatabaseTypeEnum, DatabaseTypeBinding>();
        bindings.put(String, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -5155039606411608898L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getString(columnName);
            }

            @Override
            public Class getType() {
                return String.class;
            }
        });
        bindings.put(BigDecimal, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -648825691097776732L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getBigDecimal(columnName);
            }

            @Override
            public Class getType() {
                return BigDecimal.class;
            }
        });
        bindings.put(Boolean, new DatabaseTypeBinding(){
            private static final long serialVersionUID = 5760469994325386982L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getBoolean(columnName);
            }

            @Override
            public Class getType() {
                return Boolean.class;
            }
        });
        bindings.put(Byte, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -2840004368317980229L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getByte(columnName);
            }

            @Override
            public Class getType() {
                return Byte.class;
            }
        });
        bindings.put(ByteArray, new DatabaseTypeBinding(){
            private static final long serialVersionUID = 7531500030996242544L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getBytes(columnName);
            }

            @Override
            public Class getType() {
                return byte[].class;
            }
        });
        bindings.put(Double, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -7421693646427315376L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getDouble(columnName);
            }

            @Override
            public Class getType() {
                return Double.class;
            }
        });
        bindings.put(Float, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -3368945008278992912L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return java.lang.Float.valueOf(resultSet.getFloat(columnName));
            }

            @Override
            public Class getType() {
                return Float.class;
            }
        });
        bindings.put(Int, new DatabaseTypeBinding(){
            private static final long serialVersionUID = 84694877489363201L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getInt(columnName);
            }

            @Override
            public Class getType() {
                return Integer.class;
            }
        });
        bindings.put(Long, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -1021242584650775564L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getLong(columnName);
            }

            @Override
            public Class getType() {
                return Long.class;
            }
        });
        bindings.put(Short, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -2922908857447642497L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getShort(columnName);
            }

            @Override
            public Class getType() {
                return Short.class;
            }
        });
        bindings.put(SqlDate, new DatabaseTypeBinding(){
            private static final long serialVersionUID = 7869800941910757215L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getDate(columnName);
            }

            @Override
            public Class getType() {
                return Date.class;
            }
        });
        bindings.put(SqlTime, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -5259494991875064798L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getTime(columnName);
            }

            @Override
            public Class getType() {
                return Time.class;
            }
        });
        bindings.put(SqlTimestamp, new DatabaseTypeBinding(){
            private static final long serialVersionUID = -8708251362439431175L;

            @Override
            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getTimestamp(columnName);
            }

            @Override
            public Class getType() {
                return Timestamp.class;
            }
        });
    }
}

