/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.EPException;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceLoader {
    public static URL resolveClassPathOrURLResource(String resourceName, String urlOrClasspathResource, ClassLoader classLoader) {
        URL url;
        try {
            url = new URL(urlOrClasspathResource);
        }
        catch (MalformedURLException ex) {
            url = ResourceLoader.getClasspathResourceAsURL(resourceName, urlOrClasspathResource, classLoader);
        }
        return url;
    }

    public static URL getClasspathResourceAsURL(String resourceName, String resource, ClassLoader classLoader) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        URL url = null;
        if (classLoader != null) {
            url = classLoader.getResource(stripped);
        }
        if (url == null) {
            url = ResourceLoader.class.getResource(resource);
        }
        if (url == null) {
            url = ResourceLoader.class.getClassLoader().getResource(stripped);
        }
        if (url == null) {
            throw new EPException(resourceName + " resource '" + resource + "' not found");
        }
        return url;
    }
}

