/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.util.SimpleNumberCoercer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SimpleNumberCoercerFactory {
    private static SimpleNumberCoercerNull nullCoerce = new SimpleNumberCoercerNull();
    private static SimpleNumberCoercerDouble doubleCoerce = new SimpleNumberCoercerDouble();
    private static SimpleNumberCoercerLong longCoerce = new SimpleNumberCoercerLong();
    private static SimpleNumberCoercerFloat floatCoerce = new SimpleNumberCoercerFloat();
    private static SimpleNumberCoercerInt intCoerce = new SimpleNumberCoercerInt();
    private static SimpleNumberCoercerShort shortCoerce = new SimpleNumberCoercerShort();
    private static SimpleNumberCoercerByte byteCoerce = new SimpleNumberCoercerByte();
    private static SimpleNumberCoercerBigInt bigIntCoerce = new SimpleNumberCoercerBigInt();
    private static SimpleNumberCoercerBigIntNull bigIntCoerceNull = new SimpleNumberCoercerBigIntNull();
    private static SimpleNumberCoercerBigDecLong bigDecCoerceLong = new SimpleNumberCoercerBigDecLong();
    private static SimpleNumberCoercerBigDecDouble bigDecCoerceDouble = new SimpleNumberCoercerBigDecDouble();
    private static SimpleNumberCoercerBigDecNull bigDecCoerceNull = new SimpleNumberCoercerBigDecNull();

    public static SimpleNumberBigDecimalCoercer getCoercerBigDecimal(Class fromType) {
        if (fromType == BigDecimal.class) {
            return bigDecCoerceNull;
        }
        if (JavaClassHelper.isFloatingPointClass(fromType)) {
            return bigDecCoerceDouble;
        }
        return bigDecCoerceLong;
    }

    public static SimpleNumberBigIntegerCoercer getCoercerBigInteger(Class fromType) {
        if (fromType == BigInteger.class) {
            return bigIntCoerceNull;
        }
        return bigIntCoerce;
    }

    public static SimpleNumberCoercer getCoercer(Class fromType, Class resultBoxedType) {
        if (fromType == resultBoxedType) {
            return nullCoerce;
        }
        if (resultBoxedType == Double.class) {
            return doubleCoerce;
        }
        if (resultBoxedType == Long.class) {
            return longCoerce;
        }
        if (resultBoxedType == Float.class) {
            return floatCoerce;
        }
        if (resultBoxedType == Integer.class) {
            return intCoerce;
        }
        if (resultBoxedType == Short.class) {
            return shortCoerce;
        }
        if (resultBoxedType == Byte.class) {
            return byteCoerce;
        }
        if (resultBoxedType == BigInteger.class) {
            return bigIntCoerce;
        }
        if (resultBoxedType == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointClass(fromType)) {
                return bigDecCoerceDouble;
            }
            return bigDecCoerceLong;
        }
        throw new IllegalArgumentException("Cannot coerce to number subtype " + resultBoxedType.getName());
    }

    private static class SimpleNumberCoercerBigDecNull
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        private SimpleNumberCoercerBigDecNull() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        @Override
        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return (BigDecimal)numToCoerce;
        }

        @Override
        public Class getReturnType() {
            return Number.class;
        }
    }

    private static class SimpleNumberCoercerBigIntNull
    implements SimpleNumberCoercer,
    SimpleNumberBigIntegerCoercer {
        private SimpleNumberCoercerBigIntNull() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        @Override
        public BigInteger coerceBoxedBigInt(Number numToCoerce) {
            return (BigInteger)numToCoerce;
        }

        @Override
        public Class getReturnType() {
            return Number.class;
        }
    }

    private static class SimpleNumberCoercerBigDecDouble
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        private SimpleNumberCoercerBigDecDouble() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return new BigDecimal(numToCoerce.doubleValue());
        }

        @Override
        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return new BigDecimal(numToCoerce.doubleValue());
        }

        @Override
        public Class getReturnType() {
            return Double.class;
        }
    }

    private static class SimpleNumberCoercerBigDecLong
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        private SimpleNumberCoercerBigDecLong() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return new BigDecimal(numToCoerce.longValue());
        }

        @Override
        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return new BigDecimal(numToCoerce.longValue());
        }

        @Override
        public Class getReturnType() {
            return Long.class;
        }
    }

    private static class SimpleNumberCoercerBigInt
    implements SimpleNumberCoercer,
    SimpleNumberBigIntegerCoercer {
        private SimpleNumberCoercerBigInt() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }

        @Override
        public BigInteger coerceBoxedBigInt(Number numToCoerce) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }

        @Override
        public Class getReturnType() {
            return Long.class;
        }
    }

    private static class SimpleNumberCoercerByte
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerByte() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.byteValue();
        }

        @Override
        public Class getReturnType() {
            return Byte.class;
        }
    }

    private static class SimpleNumberCoercerShort
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerShort() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.shortValue();
        }

        @Override
        public Class getReturnType() {
            return Short.class;
        }
    }

    private static class SimpleNumberCoercerFloat
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerFloat() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return Float.valueOf(numToCoerce.floatValue());
        }

        @Override
        public Class getReturnType() {
            return Float.class;
        }
    }

    private static class SimpleNumberCoercerInt
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerInt() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.intValue();
        }

        @Override
        public Class getReturnType() {
            return Integer.class;
        }
    }

    private static class SimpleNumberCoercerLong
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerLong() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.longValue();
        }

        @Override
        public Class getReturnType() {
            return Long.class;
        }
    }

    private static class SimpleNumberCoercerDouble
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerDouble() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.doubleValue();
        }

        @Override
        public Class getReturnType() {
            return Double.class;
        }
    }

    private static class SimpleNumberCoercerNull
    implements SimpleNumberCoercer {
        private SimpleNumberCoercerNull() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        @Override
        public Class getReturnType() {
            return Number.class;
        }
    }
}

