/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.util.ClassForNameProvider;
import com.espertech.esper.client.util.ClassForNameProviderDefault;
import com.espertech.esper.client.util.ClassLoaderProvider;
import com.espertech.esper.client.util.ClassLoaderProviderDefault;
import com.espertech.esper.client.util.FastClassClassLoaderProvider;
import com.espertech.esper.client.util.FastClassClassLoaderProviderDefault;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientConfigurationResolver {
    private static final Logger log = LoggerFactory.getLogger(TransientConfigurationResolver.class);

    public static ClassForNameProvider resolveClassForNameProvider(Map<String, Object> transientConfiguration) {
        return TransientConfigurationResolver.resolve(transientConfiguration, ClassForNameProviderDefault.INSTANCE, "ClassForNameProvider", ClassForNameProvider.class);
    }

    public static FastClassClassLoaderProvider resolveFastClassClassLoaderProvider(Map<String, Object> transientConfiguration) {
        return TransientConfigurationResolver.resolve(transientConfiguration, FastClassClassLoaderProviderDefault.INSTANCE, "FastClassClassLoaderProvider", FastClassClassLoaderProvider.class);
    }

    public static ClassLoaderProvider resolveClassLoader(Map<String, Object> transientConfiguration) {
        return TransientConfigurationResolver.resolve(transientConfiguration, ClassLoaderProviderDefault.INSTANCE, "ClassLoaderProvider", ClassLoaderProvider.class);
    }

    private static <T> T resolve(Map<String, Object> transientConfiguration, T defaultProvider, String name, Class interfaceClass) {
        if (transientConfiguration == null) {
            return defaultProvider;
        }
        Object value = transientConfiguration.get(name);
        if (value == null) {
            return defaultProvider;
        }
        if (!JavaClassHelper.isImplementsInterface(value.getClass(), interfaceClass)) {
            log.warn("For transient configuration '" + name + "' expected an object implementing " + interfaceClass.getName() + " but received " + value.getClass() + ", using default provider");
            return defaultProvider;
        }
        return (T)value;
    }
}

