/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.spec.PluggableObjectEntry;
import com.espertech.esper.epl.spec.PluggableObjectRegistry;
import com.espertech.esper.epl.spec.PluggableObjectType;
import com.espertech.esper.epl.virtualdw.VirtualDWViewFactoryImpl;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.ViewResolutionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewResolutionServiceImpl
implements ViewResolutionService {
    private static final Logger log = LoggerFactory.getLogger(ViewResolutionServiceImpl.class);
    private final PluggableObjectRegistry viewObjects;
    private final String optionalNamedWindowName;
    private final Class virtualDataWindowViewFactory;

    public ViewResolutionServiceImpl(PluggableObjectRegistry viewObjects, String optionalNamedWindowName, Class virtualDataWindowViewFactory) {
        this.viewObjects = viewObjects;
        this.optionalNamedWindowName = optionalNamedWindowName;
        this.virtualDataWindowViewFactory = virtualDataWindowViewFactory;
    }

    @Override
    public ViewFactory create(String nameSpace, String name) throws ViewProcessingException {
        ViewFactory viewFactory;
        if (log.isDebugEnabled()) {
            log.debug(".create Creating view factory, namespace=" + nameSpace + " name=" + name);
        }
        Class viewFactoryClass = null;
        Pair<Class, PluggableObjectEntry> pair = this.viewObjects.lookup(nameSpace, name);
        if (pair != null) {
            if (pair.getSecond().getType() == PluggableObjectType.VIEW) {
                if (this.optionalNamedWindowName != null && this.virtualDataWindowViewFactory != null) {
                    return new VirtualDWViewFactoryImpl(this.virtualDataWindowViewFactory, this.optionalNamedWindowName, null);
                }
                viewFactoryClass = pair.getFirst();
            } else {
                if (pair.getSecond().getType() == PluggableObjectType.VIRTUALDW) {
                    if (this.optionalNamedWindowName == null) {
                        throw new ViewProcessingException("Virtual data window requires use with a named window in the create-window syntax");
                    }
                    return new VirtualDWViewFactoryImpl(pair.getFirst(), this.optionalNamedWindowName, pair.getSecond().getCustomConfigs());
                }
                throw new ViewProcessingException("Invalid object type '" + pair.getSecond() + "' for view '" + name + "'");
            }
        }
        if (viewFactoryClass == null) {
            String message = nameSpace == null ? "View name '" + name + "' is not a known view name" : "View name '" + nameSpace + ":" + name + "' is not a known view name";
            throw new ViewProcessingException(message);
        }
        try {
            viewFactory = (ViewFactory)viewFactoryClass.newInstance();
            if (log.isDebugEnabled()) {
                log.debug(".create Successfully instantiated view");
            }
        }
        catch (ClassCastException e) {
            String message = "Error casting view factory instance to " + ViewFactory.class.getName() + " interface for view '" + name + "'";
            throw new ViewProcessingException(message, e);
        }
        catch (IllegalAccessException e) {
            String message = "Error invoking view factory constructor for view '" + name;
            message = message + "', no invocation access for Class.newInstance";
            throw new ViewProcessingException(message, e);
        }
        catch (InstantiationException e) {
            String message = "Error invoking view factory constructor for view '" + name;
            message = message + "' using Class.newInstance";
            throw new ViewProcessingException(message, e);
        }
        return viewFactory;
    }
}

