/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.View;
import com.espertech.esper.view.Viewable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ViewSupport
implements View {
    public static final View[] EMPTY_VIEW_ARRAY = new View[0];
    protected Viewable parent;
    private View[] children = EMPTY_VIEW_ARRAY;
    private static final Logger log = LoggerFactory.getLogger(ViewSupport.class);

    protected ViewSupport() {
    }

    @Override
    public Viewable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Viewable parent) {
        this.parent = parent;
    }

    @Override
    public View addView(View view) {
        this.children = ViewSupport.addView(this.children, view);
        view.setParent(this);
        return view;
    }

    @Override
    public boolean removeView(View view) {
        int index = ViewSupport.findViewIndex(this.children, view);
        if (index == -1) {
            return false;
        }
        this.children = ViewSupport.removeView(this.children, index);
        view.setParent(null);
        return true;
    }

    @Override
    public void removeAllViews() {
        this.children = EMPTY_VIEW_ARRAY;
    }

    @Override
    public View[] getViews() {
        return this.children;
    }

    @Override
    public boolean hasViews() {
        return this.children.length > 0;
    }

    public void updateChildren(EventBean[] newData, EventBean[] oldData) {
        int size = this.children.length;
        if (size == 0) {
            return;
        }
        if (size == 1) {
            this.children[0].update(newData, oldData);
        } else {
            for (View child : this.children) {
                child.update(newData, oldData);
            }
        }
    }

    protected static void updateChildren(Collection<View> childViews, EventBean[] newData, EventBean[] oldData) {
        for (View child : childViews) {
            child.update(newData, oldData);
        }
    }

    public static void dumpUpdateParams(String prefix, UniformPair<EventBean[]> result) {
        Object[] newEventArr = result != null ? result.getFirst() : null;
        Object[] oldEventArr = result != null ? result.getSecond() : null;
        ViewSupport.dumpUpdateParams(prefix, newEventArr, oldEventArr);
    }

    public static void dumpUpdateParams(String prefix, Object[] newData, Object[] oldData) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        if (newData == null) {
            writer.println(prefix + " newData=null ");
        } else {
            writer.println(prefix + " newData.size=" + newData.length + "...");
            ViewSupport.printObjectArray(prefix, writer, newData);
        }
        if (oldData == null) {
            writer.println(prefix + " oldData=null ");
        } else {
            writer.println(prefix + " oldData.size=" + oldData.length + "...");
            ViewSupport.printObjectArray(prefix, writer, oldData);
        }
    }

    private static void printObjectArray(String prefix, PrintWriter writer, Object[] objects) {
        int count = 0;
        for (Object object : objects) {
            String objectToString = object == null ? "null" : object.toString();
            writer.println(prefix + " #" + count + " = " + objectToString);
        }
    }

    public static void dumpChildViews(String prefix, Viewable parentViewable) {
        if (log.isDebugEnabled() && parentViewable != null && parentViewable.getViews() != null) {
            for (View child : parentViewable.getViews()) {
                if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                    log.debug(".dumpChildViews " + prefix + ' ' + child.toString());
                }
                ViewSupport.dumpChildViews(prefix + "  ", child);
            }
        }
    }

    public static List<View> findDescendent(Viewable parentView, Viewable descendentView) {
        Stack<View> stack = new Stack<View>();
        for (View view : parentView.getViews()) {
            if (view == descendentView) {
                return stack;
            }
            boolean found = ViewSupport.findDescendentRecusive(view, descendentView, stack);
            if (!found) continue;
            return stack;
        }
        return null;
    }

    private static boolean findDescendentRecusive(View parentView, Viewable descendentView, Stack<View> stack) {
        stack.push(parentView);
        boolean found = false;
        for (View view : parentView.getViews()) {
            if (view == descendentView) {
                return true;
            }
            found = ViewSupport.findDescendentRecusive(view, descendentView, stack);
            if (found) break;
        }
        if (!found) {
            stack.pop();
            return false;
        }
        return true;
    }

    public static View[] addView(View[] children, View view) {
        if (children.length == 0) {
            return new View[]{view};
        }
        return (View[])CollectionUtil.arrayExpandAddSingle(children, view);
    }

    public static int findViewIndex(View[] children, View view) {
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != view) continue;
            return i;
        }
        return -1;
    }

    public static View[] removeView(View[] children, int index) {
        if (children.length == 1) {
            return EMPTY_VIEW_ARRAY;
        }
        return (View[])CollectionUtil.arrayShrinkRemoveSingle(children, index);
    }
}

