/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitableContainer;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewDataVisitorContained;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.IntersectBatchViewLocalState;
import com.espertech.esper.view.internal.IntersectDefaultView;
import com.espertech.esper.view.internal.IntersectViewFactory;
import com.espertech.esper.view.internal.IntersectViewMarker;
import com.espertech.esper.view.internal.LastPostObserver;
import com.espertech.esper.view.internal.LastPostObserverView;
import com.espertech.esper.view.internal.ViewContainer;
import java.util.Iterator;
import java.util.List;

public class IntersectBatchView
extends ViewSupport
implements LastPostObserver,
CloneableView,
StoppableView,
DataWindowView,
IntersectViewMarker,
ViewDataVisitableContainer,
ViewContainer {
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    protected final IntersectViewFactory factory;
    protected final View[] views;

    public IntersectBatchView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, IntersectViewFactory factory, List<View> viewList) {
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.factory = factory;
        this.views = viewList.toArray(new View[viewList.size()]);
        for (int i = 0; i < viewList.size(); ++i) {
            LastPostObserverView view = new LastPostObserverView(i);
            this.views[i].removeAllViews();
            this.views[i].addView(view);
            view.setObserver(this);
        }
    }

    @Override
    public View[] getViewContained() {
        return this.views;
    }

    @Override
    public View cloneView() {
        return this.factory.makeView(this.agentInstanceViewFactoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        IntersectBatchViewLocalState localState = this.factory.getBatchViewLocalStatePerThread();
        if (oldData != null && oldData.length != 0) {
            try {
                localState.setIgnoreViewIRStream(true);
                for (i = 0; i < this.views.length; ++i) {
                    this.views[i].update(newData, oldData);
                }
            }
            finally {
                localState.setIgnoreViewIRStream(false);
            }
        }
        if (newData != null) {
            try {
                localState.setCaptureIRNonBatch(true);
                for (i = 0; i < this.views.length; ++i) {
                    if (i == this.factory.getBatchViewIndex()) continue;
                    this.views[i].update(newData, oldData);
                }
            }
            finally {
                localState.setCaptureIRNonBatch(false);
            }
            localState.getRemovedEvents().clear();
            for (i = 0; i < this.views.length; ++i) {
                if (localState.getOldEventsPerView()[i] == null) continue;
                for (int j = 0; j < this.views.length; ++j) {
                    if (i == j) continue;
                    this.views[j].update(null, localState.getOldEventsPerView()[i]);
                    for (int k = 0; k < localState.getOldEventsPerView()[i].length; ++k) {
                        localState.getRemovedEvents().add(localState.getOldEventsPerView()[i][k]);
                    }
                }
                localState.getOldEventsPerView()[i] = null;
            }
            EventBean[] newDataNonRemoved = this.factory.isHasAsymetric() ? EventBeanUtility.getNewDataNonRemoved(newData, localState.getRemovedEvents(), localState.getNewEventsPerView()) : EventBeanUtility.getNewDataNonRemoved(newData, localState.getRemovedEvents());
            if (newDataNonRemoved != null) {
                this.views[this.factory.getBatchViewIndex()].update(newDataNonRemoved, null);
            }
        }
    }

    @Override
    public EventType getEventType() {
        return this.factory.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.views[this.factory.getBatchViewIndex()].iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newData(int streamId, EventBean[] newEvents, EventBean[] oldEvents) {
        IntersectBatchViewLocalState localState = this.factory.getBatchViewLocalStatePerThread();
        if (localState.isIgnoreViewIRStream()) {
            return;
        }
        if (localState.isCaptureIRNonBatch()) {
            localState.getOldEventsPerView()[streamId] = oldEvents;
            if (this.factory.isHasAsymetric()) {
                localState.getNewEventsPerView()[streamId] = newEvents;
            }
            return;
        }
        if (streamId == this.factory.getBatchViewIndex()) {
            this.updateChildren(newEvents, oldEvents);
            if (newEvents != null) {
                try {
                    localState.setIgnoreViewIRStream(true);
                    for (int i = 0; i < this.views.length; ++i) {
                        if (i == streamId) continue;
                        this.views[i].update(null, newEvents);
                    }
                }
                finally {
                    localState.setIgnoreViewIRStream(false);
                }
            }
        } else if (oldEvents != null) {
            try {
                localState.setIgnoreViewIRStream(true);
                for (int i = 0; i < this.views.length; ++i) {
                    if (i == streamId) continue;
                    this.views[i].update(null, oldEvents);
                }
            }
            finally {
                localState.setIgnoreViewIRStream(false);
            }
        }
    }

    @Override
    public void stop() {
        for (View view : this.views) {
            if (!(view instanceof StoppableView)) continue;
            ((StoppableView)((Object)view)).stop();
        }
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        IntersectDefaultView.visitViewContained(viewDataVisitor, this.factory, this.views);
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

